package com.bizvane.members.facade.es.vo;

import com.bizvane.members.facade.models.MbrGroupModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2018\8\15 0015.
 * <p>
 * 后台接收 参数 全部兼容前端
 */
@Data
public class MembersInfoSearchVo implements Serializable {

    // 企业id
    private Long sysCompanyId;
    // 基本搜索：卡号/姓名/手机号
    private String conditions;
    // 分页参数
    private Integer pageNumber;
    private Integer pageSize;
    // 隔离门店
    private List<Long> storeList;
    // 手机号集合  2021-8-20
    private List<String> phoneList;

    // polarDB mbr主键id
    @Id
    private Long mbrMemberId;
    // 品牌号
    private Long brandId;
    // 会员code
    private String memberCode;
    // @Field(type = FieldType.Date)
    private String birthday;
    // 姓名
    private String name;
    // 手机号
    private String phone;
    // 身份证
    private String idCard;
    // erpId
    private String erpId;
    // 区域
    private List<SearchAreaRequest> area;

    // 导入卡号
    private String cardNoBatch;
    //卡号
    private String cardNo;

    // 导入手机号
    // private String phoneBatch;

    // 等级id
    private List<Long> levelID;
    // 标签ids
    private SearchExternalRequest<SearchLabelRequest> labelNames;

    // 标签
    private SearchExternalRequest<List<SearchLabelRequest>> labels;

    // 自动标签
    private SearchExternalRequest<List<SearchAutoLabelRequest>> autoLabelList;

    // 受众包标签
    private SearchExternalRequest<List<SearchQaLabelNewRequest>> qaLabelList;

    // 自动标签查询类型 1-包含查询  2-排除查询
    private Integer autoLabelSearchType;
    // 店铺查询类型 1-包含查询  2-排除查询
    private Integer storeSearchType;
    // 活跃店铺
    private SearchExternalRequest<SearchStoreRequest> activeStore;
    // 所属店铺
    private SearchExternalRequest<SearchStoreRequest> serviceStore;
    private String serviceStoreKey;
    
    // 所属导购
    private SearchExternalRequest<SearchGuideRequest> serviceGuide;
    
    private String serviceGuideKey;
    
    // 开卡店铺
    private SearchExternalRequest<SearchStoreRequest> openCardStore;
    private String openCardStoreKey;
    
    // 开卡导购
    private SearchExternalRequest<SearchGuideRequest> openCardGuide;
    
    private String openCardGuideKey;
    
    // 所属群组
    private SearchExternalRequest<SearchGroupRequest> serviceGroup;
    // 运营组织
    private SearchExternalRequest<SearchOrgRequest> serviceOrg;
    // 所属渠道
    private SearchExternalRequest<SearchChannelRequest> channelIds;

    private SearchExternalRequest<SearchChannelRequest> openCardChannelIds;

    // 0全部 1女 2男 3未知
    private Integer gender;
    // 新老会员 0.全部 1.新 2.老
    private Integer newMember;
    // 是否关注,1：未关注,2：已关注,3:已取关
    private Integer focus;
    // 绑卡状态 前端：1.是 2.否
    // 1：未绑卡,2已绑卡
    private Integer cardStatus;
    // 是否微信会员 1.是 2.否
    private Integer wxMembers;

    private Integer taobaoBindStatus;

    private Long mbrGroupDefId;

//    taobaoBindStatus 1 已绑定 2 未绑定 3 已解绑

    // 生命周期 1活跃会员 2 沉默会员 3 濒临休眠会员 4休眠会员 5流失会员
    private Integer memberLiveness;
//    //活跃会员1：是,2：否
//    private Integer activeMember;
//    //沉默会员1:是,2:否
//    private Integer silenceMember;
//    //濒临睡眠会员1:是,2:否
//    private Integer vergeSleepMember;
//    //休眠会员
//    private Integer dormancyMember;
//    //流失会员
//    private Integer awayMember;

    // 总可用积分
    private List<SearchRangRequest> integral;
    // 年龄
    private List<SearchRangRequest> age;

    private List<SearchRangRequest> balance;
    // 生日时间 YMD

    // 生日 冗余生日时间的格式月日,例如：0101
    // private List<SearchRangRequest> birthdayMD;
    private List<SearchRangRequest> birthdayMD;

    //宝宝生日
    private List<SearchRangRequest> babyBirthdayMD;


    //新 生日高级搜索
    private SearchRangeTypeRequest birthdayMdRange;

    // 新 开卡时间搜索
    private SearchTimeRangeTypeRequest openCardTimeRange;

    //新 绑卡时间搜索
    private SearchTimeRangeTypeRequest bindCardTimeRange;

    //新 首次消费日期搜索
    private SearchTimeRangeTypeRequest firstBuyTimeRange;

    //新 最近购买时间搜索
    private SearchTimeRangeTypeRequest lastBuyTimeRange;

    //新 商品购买日期
    private SearchTimeRangeTypeRequest goodsBuyTimeRange;

    // 开卡时间
    private List<SearchTimeRangRequest> openCardTime;
    // 绑卡时间
    private List<SearchTimeRangRequest> bindCardTime;
    // 首次购买时间
    private List<SearchTimeRangRequest> firstBuyTime;
    // 最近购买时间
    private List<SearchTimeRangRequest> lastBuyTime;

    // 消费金额累计
    private List<SearchRangRequest> consumeAmount;
    // 消费次数
    private List<SearchRangRequest> consumeNumber;
    // 消费件数
    private List<SearchRangRequest> consumeCount;
    // 退款次数
    private List<SearchRangRequest> refundNumber;
    // 退款金额
    private List<SearchRangRequest> refundAmount;
    // 成交价
    private List<SearchRangRequest> dealPrice;
    // 吊牌价
    private List<SearchRangRequest> tagPrice;
    // 客单价金额
    private SearchRangRequest pctAmount;
    // 折扣率
    private SearchRangRequest discountRate;
    // 连带率件数
    private SearchRangRequest aprNumber;

    // 优惠券
    // 券总数
    private Integer couponTotalNumber;
    // 已使用
    private Integer couponUseNumber;
    // 未使用
    private Integer couponUnusedNumber;
    // 已过期
    private Integer couponPastDueNumber;
    // 扩展字段
    private List<SearchExtendRequest> extendValue;

    private List<List<SkuSpecRequest>> specs;

    private List<List<SkuPropertyRequest>> properties;
    // 商品规格解析数据字段
    private List<NewSkuSpecRequest> newSpecs;
    // 商品属性解析数据字段
    private List<NewSkuPropertyRequest> newProperties;
    
    private List<List<String>> specsKey;

    private List<List<String>> propertiesKey;

    private List<List<SkuCategoryRequest>> categories;

    private List<List<String>> productCodes;
    
    private List<String> productCodesKeyList;


    private Integer valid;

    // ============
    @ApiModelProperty(value = "会员范围:1微信会员，2全部会员", name = "memberScope")
    private String memberScope;

    @ApiModelProperty(value = "生日时间线", name = "birthdayLine")
    private Integer birthdayLine;

    @ApiModelProperty(value = "宝宝生日时间线", name = "babyBirthdayLine")
    private Integer babyBirthdayLine;

    @ApiModelProperty(value = "注册时间线", name = "openCardTimeLine")
    private Integer openCardTimeLine;

    // ===============会员分销================
    @ApiModelProperty(value = "分销状态", name = "distributionState")
    private Integer distributionState;

    @ApiModelProperty(value = "所属门店", name = "serviceStoreId")
    private Long serviceStoreId;

    @ApiModelProperty(name = "createStartTime", value = "创建时间前")
    private String createStartTime;

    @ApiModelProperty(name = "createEndTime", value = "创建时间后")
    private String createEndTime;

    @ApiModelProperty(name = "modifiedStartTime", value = "修改时间前")
    private String modifiedStartTime;

    @ApiModelProperty(name = "modifiedEndTime", value = "修改时间后")
    private String modifiedEndTime;

    @ApiModelProperty(name = "memberComment", value = "会员备注")
    private String memberComment;
    @ApiModelProperty(name = "wxNick", value = "微信昵称")
    private String wxNick;

    private String friendsConditions;

    // 会员导购好友
    private SearchExternalRequest<SearchFriendsRequest> companyGuideFriends;
    // 性别集合
    private List<Integer> genderList;

    // 资料完整度占比
    private Integer dataIntegrityPercentage;

    private SearchPhoneBatchRequest phoneBatch;

    //增加邮箱搜索
    private SearchEmailBatchRequest emailBatch;

    // memberCode集合
    private List<String> memberCodeList;

    // 是否企业好友 1是 0否
    private Integer companyFriend;


    private List<String> productCodeList;

    @ApiModelProperty(name = "productCode", value = "商品编码")
    private String productCode;
    @ApiModelProperty(name = "cata1PrdList", value = "品类集合")
    private SearchExternalRequest<String> cata1PrdList;

    @ApiModelProperty(name = "cata2PrdList", value = "中类集合")
    private SearchExternalRequest<String> cata2PrdList;
    @ApiModelProperty(name = "cata3PrdList", value = "小类集合")
    private SearchExternalRequest<String> cata3PrdList;
    @ApiModelProperty(name = "seasonPrdList", value = "季节集合")
    private SearchExternalRequest<String> seasonPrdList;

    // 二维码渠道
    private SearchExternalRequest<SearchQrCodeRequest> qrCodeChannel;

    @ApiModelProperty(name = "levelUpTime", value = "升级时间节点")
    private Date levelUpTimeNode;


    // 标签id
    private List<Long> labelsID;

    //开卡开始时间
    private Date openCardTimeFrom;

    @ApiModelProperty(value = "开卡开始时间", name = "openCardDateFrom")
    private String openCardDateFrom;

    @ApiModelProperty(value = "开卡结束时间", name = "openCardDateTo")
    private String openCardDateTo;

    // 是否降序
    private Boolean isDesc;

    private Integer orderType;


    @ApiModelProperty(name = "openCardTimeSection", value = "开卡时间区间(支持半开区间) 区间内关系-或")
    private List<FlexibleTimeRange> openCardTimeSection;


    @ApiModelProperty(name = "upgradeTimeSection", value = "升级时间区间(支持半开区间) 区间内关系-或")
    private List<FlexibleTimeRange> upgradeTimeSection;


    @ApiModelProperty(name = "openCardTimeSection", value = "降级时间区间(支持半开区间) 区间内关系-或")
    private List<FlexibleTimeRange> downGradeTimeSection;

    @ApiModelProperty(name = "levelUpTimeSection",value = "升级时间区间(支持半开区间)区间内关系-或")
    private List<FlexibleTimeRange> levelUpTimeSection;

    @ApiModelProperty(name = "levelDownTimeSection",value = "降级时间区间(支持半开区间) 区间内关系-或")
    private List<FlexibleTimeRange> levelDownTimeSection;

    @ApiModelProperty(name = "consume2LevelCombinationSearches", value = "会员等级和消费属性时间区间(支持半开区间) 区间内关系-或")
    private List<Consume2LevelCombinationSearch> consume2LevelCombinationSearches;


    // 成长值
    private List<SearchRangRequest> growthNum;


    private String scrollId;

    //361 vip卡状态 0未激活 1激活 2停用 3挂失 4冻结 6:注销
    private Integer cardUseStatus;
    //运营组织
    private String onlineOrgCode;

    private List<Order> orders;

    @ApiModelProperty(name = "createTimeNode", value = "创建时间节点")
    private Date createTimeNode;

    //会员分组mbrGroupDefId
    private String childMbrGroupDefIdsStr;

    private SearchExternalRequest<List<MbrGroupModel>> childMbrGroupDefIds;

    private Integer integralSwitch;

    private Integer growthSwitch;

    private List<SearchRangRequest> mbrMemberIdRanges;


    //关注公众号 1未关注 2 关注中 3已取关
    private Integer focusPublic;

    // 区分 ==  或者 !=
    private boolean memberCodeListHas;

    //正选memberCodes
    private List<String> positiveMemberCodes;
    //反选memberCodes
    private List<String> negativeMemberCodes;

    //Qa标签
    private SearchExternalRequest<SearchQaLabelRequest> qaLabels;

    //消费渠道 1-线下零售单 2-微商城  4-云仓订单
    private List<Integer> consumeChannelFrom;

    //自定义标签
    private List<Long> customLabelIds;

    //是否支持跨组织查询会员
    private Boolean isCrossOrgQuery;

    private List<String> unionIdList;

    // 排除品牌列表
    private List<Long> excludeSysBrandIdList;
    
    private String excludeMktBirthday;

    @ApiModelProperty(value = "true:已分配过服务导购的会员(不包含默认导购的会员); false:服务导购为空，或默认导购; null:按原有查询逻辑", name = "isAssigned", example = "是否已分配服务导购")
    private Boolean isAssigned;
    
    //即将过期积分
    private List<SearchRangRequest> expiringIntegral;
    
    //即将过期积分
    private List<SearchRangRequest> aboutExpireIntegral;

    // 累计充值金额
    private List<SearchRangRequest> rechargeAmount;

    // 累计充值次数
    private List<SearchRangRequest> rechargeNumber;

    // 充值时间
    private SearchTimeRangeTypeRequest rechargeTimeRange;

    // erpId
    private List<String> erpIdList;

    @ApiModelProperty(name = "updateStartTime", value = "开始更新时间")
    private String updateStartTime;

    @ApiModelProperty(name = "updateEndTime", value = "结束更新时间")
    private String updateEndTime;


}
