package com.bizvane.members.facade.enums;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/13.
 */
public enum OpenCardChannelEnum {
    /**
     * 会员开卡绑卡渠道 线下渠道->POS
     */
    OFFLINE_CHANNEL(1L, "线下渠道"),
    /**
     * 会员开卡绑卡渠道 微信渠道->微信会员中心
     */
    WECHAT_CHANNEL(2L, "微信会员中心小程序"),
    /**
     * 会员开卡绑卡渠道 支付宝渠道->支付宝会员中心
     */
    ALIPAY_CHANNEL(3L, "支付宝会员中心小程序"),
    /**
     * 会员开卡绑卡渠道 天猫渠道->天猫
     */
    TAOBAO_CHANNEL(4L, "天猫商城"),
    /**
     * 会员开卡绑卡渠道 电子会员卡渠道->微信电子会员卡
     */
    ELECTCARD_CHANNEL(5L, "微信电子会员卡"),
    /**
     * 会员开卡绑卡渠道 微商城
     */
    MALL(6L, "商帆微商城"),
    /**
     * 会员开卡绑卡渠道 手动导入渠道->手动导入
     */
    IMPORT_CHANNEL(7L, "手工导入"),
    /**
     * 会员开卡绑卡渠道 微盟商城
     */
    MALL_WEIMOB_CHANNEL(8L, "微盟微商城"),
    /**
     * 会员开卡绑卡渠道 EHR
     */
    EHR(9L,"EHR"),
    /**
     * 会员开卡绑卡渠道 其它渠道->其它
     */
    OTHER_CHANNEL(10L,"其它"),
    /**
     * 会员开卡绑卡渠道 有赞渠道->有赞商城
     */
    YOUZAN_CHANNEL(11L,"有赞微商城"),
    /**
     * 会员开卡绑卡渠道 南讯渠道
     */
    NANXUN_CHANNEL(12L,"南讯渠道"),
    /**
     * 会员开卡绑卡渠道 支付宝电子会员卡渠道->支付宝电子会员卡
     */
    ALIPAY_ELECTCARD_CHANNEL(13L, "支付宝电子会员卡"),
    /**
     * 会员开卡绑卡渠道 商帆新微商城
     */
    SF_NEW_MALL(14L,"商帆新微商城"),
    /**
     * 会员开卡绑卡渠道 官网
     */
    OFFICIAL_WEBSITE_CHANNEL(15L,"官网"),
    /**
     * 会员开卡绑卡渠道 视频号小店
     */
    SMALL_SHOP_CHANNEL(16L,"视频号小店");

    private Long code;

    private String msg;

    OpenCardChannelEnum(Long code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }


    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getOpenCardChanneMessage(Long code) {
        for (OpenCardChannelEnum type : OpenCardChannelEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }
}
