package com.bizvane.members.facade.vo.qywx;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.bizvane.members.facade.es.vo.SearchExternalRequest;
import com.bizvane.members.facade.es.vo.SearchGuideRequest;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class MbrDefinedGroupInfoRequestVo {
    @ApiModelProperty(value = "主键", name = "definedGroupId", required = true)
    @NotNull
    private Long definedGroupId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", required = false)
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
    @NotNull
    private Long sysBrandId;

    @ApiModelProperty(value = "店铺集合", name = "storeList", required = false)
    private List<Long> storeList;

    // 所属导购
    private SearchExternalRequest<SearchGuideRequest> serviceGuide;

    // 导购id
    private Long guideId;

    // 导购助手角色
    private String staffRoleId;

    private Integer pageNum;

    private Integer pageSize;

    // 1 兼容商秀 店长身份 查看待分配会员
    private Integer type;
}
