package com.bizvane.members.facade.utils;

import com.bizvane.exporttask.common.bean.ResultBean;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.Objects;

/**
 * 基础服务返回处理工具类
 * @author huangxinliu
 * @date: 2021/2/4 10:36
 */
public class BasicServiceResUtil {

    /** 添加导出任务成功提示 */
    public static final String EXPORT_SUC_MSG = "添加导出任务成功";

    /**
     * 转换ResponseData
     * @param res
     * @param successMsg
     * @return
     */
    public static ResponseData convertResponseData(ResultBean<Boolean> res, String successMsg){
        if(Objects.isNull(res) || !res.getSuccess()){
            return getFailedData(null, "请求失败，请稍候重新尝试");
        }
        if(res.getResult()){
            return getSuccessData(null, successMsg);
        }else{
            return getFailedData(res.getErrorInfo(), res.getErrorInfo().getMsg());
        }
    }

    /**
     * 获取成功响应
     * @param data
     * @return
     */
    public static ResponseData getSuccessData(Object data) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(data);
        return responseData;
    }

    /**
     * 获取成功响应
     * @param data
     * @param msg
     * @return
     */
    public static ResponseData getSuccessData(Object data, String msg) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(msg);
        responseData.setData(data);
        return responseData;
    }

    /**
     * 获取失败响应
     * @param data
     * @param msg
     * @return
     */
    public static ResponseData getFailedData(Object data, String msg) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(msg);
        responseData.setData(data);
        return responseData;
    }

}
