package com.bizvane.members.facade.service.inner;

import com.bizvane.exporttask.remote.dto.MemberTagRequestDto;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.*;
import com.bizvane.members.facade.models.bo.BatchTaskBo;
import com.bizvane.members.facade.models.excel.LabelExcelModel;
import com.bizvane.members.facade.models.excel.LabelExcelPO;
import com.bizvane.members.facade.models.po.MbrLabelDefPO;
import com.bizvane.members.facade.vo.ImportBatchAddLabelReqVo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.members.facade.vo.SingleLabelReqVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;


/**
 * @author houkai
 */
public interface MemberLabelService {
    /**
     * 添加标签(批量)
     *
     * @param memberLabelModel
     * @return
     * @throws MemberException
     */
    ResponseData addLabels(MemberLabelModel memberLabelModel) throws MemberException;

    /**
     * 查询标签列表
     *
     * @param
     * @param pageVo
     * @return
     */
    PageInfo<MemberLabelModel> queryLabelList(MemberLabelModel memberLabelModel, PageVo pageVo);

    /**
     * 查询标签详情
     *
     * @param labelId
     * @return
     */
    MemberLabelModel queryLabelInfo(long labelId);

    /**
     * 根据id删除标签
     *
     * @param memberLabelModel
     * @return
     * @throws MemberException
     */
    ResponseData updateLabelValid(MemberLabelModel memberLabelModel) throws MemberException;

    /**
     * 添加标签计数
     *
     * @param labelId
     * @return
     * @throws MemberException
     */
    ResponseData addCount(long labelId) throws MemberException;

    /**
     * 根据品牌查询标签分页列表
     *
     * @param brandId
     * @param pageVo
     * @return
     */
    ResponseData<PageInfo<MemberLabelModel>> queryLabelsByBrandId(long brandId, PageVo pageVo);

    /**
     * 标签导出查询
     *
     * @param memberLabelModel
     * @return
     */
    List<LabelExcelModel> queryLabels(MemberLabelModel memberLabelModel);

    /**
     * 添加会员标签(单个)
     *
     * @param memberLabelModel
     * @return
     */
    ResponseData addLabel(MemberLabelModel memberLabelModel);

    /**
     * 导入标签
     *
     * @param url
     * @param currentUser
     * @return
     */
    ResponseData importLabelExcel(String url, SysAccountPO currentUser);

    /**
     * 导入标签(批次任务)
     * @param url
     * @param currentUser
     * @return
     */
    ResponseData importLabelExcelTask(String url, SysAccountPO currentUser);

    /**
     * 导出excel任务添加
     *
     * @param memberLabelModel
     * @return
     */
    ResponseData exportToExcel(MemberLabelModel memberLabelModel,SysAccountPO currentUser);
    

    /**
     * 查询自定义标签
     * @param requestVO
     * @return
     */
    ResponseData<PageInfo<MbrLabelDefPO>> queryCustomizeLabelList(PageVo pageVo, QueryCustomizeLabelListRequestVO requestVO);
    
    
    ResponseData<String> exportCustomizeLabelList(QueryCustomizeLabelListRequestVO requestVO,Optional<SysAccountPO> optional);


    ResponseData exportNewToExcel(MemberLabelModel memberLabelModel,SysAccountPO currentUser);

     void addExcelLabel(LabelExcelPO labelExcelPo, SysAccountPO currentUser);


    void addNewExcelLabel(Set<LabelExcelPO> labelExcelPos, SysAccountPO currentUser);


    void addNewLabel(MemberLabelModel memberLabelModel);

    void deleteLabelForMembers(Long labelId,Long sysAccountId,String name);

    /**
     * 标签 加入/移除 回收站
     *
     * @param memberLabelModel 标签信息
     * @param optional 当前登陆用户
     * @return
     */
    ResponseData<String> joinOrRemoveRecycleBin(MemberLabelModel memberLabelModel, Optional<SysAccountPO> optional);


    /**
     * 批量导入手机号帖标签
     *
     * @param requestVo 请求参数
     * @param optional  登陆人信息
     * @return
     */
    ResponseData<String> importExcelBatchPostLabel(ImportBatchAddLabelReqVo requestVo, Optional<SysAccountPO> optional);


    ResponseData<BatchTaskBo> batchImportLabelTask(ImportBatchAddLabelReqVo requestVo, Optional<SysAccountPO> optional);


    void asyncBatchImportLabelTask(ImportBatchAddLabelReqVo requestVo, BatchTaskBo batchTaskBo);


    void asyncRetryImportLabelTask(BatchTaskBo batchTaskBo);

    /**
     * 导出标签日志
     * @param requestVo
     * @param currentUser
     */
    ResponseData exportMemberTagLog(MemberTagRequestDto requestVo, SysAccountPO currentUser);

    /**
     *  单个会员编辑标签
     * @param singleLabelReqVo
     * @param
     * @return
     */
    ResponseData singleImportLabel(SingleLabelReqVo singleLabelReqVo);

    /**
     * 修改标签是否允许导购操作状态
     * @param memberLabelModel
     * @return
     */
    ResponseData updateLabelOpenStaffById(MemberLabelModel memberLabelModel);

    /**
     * 根据标签id更新企微标签id
     * @param sysBrandId
     * @param mbrLabelId
     * @param wxqyTagId
     * @return
     */
    ResponseData<String> updateTagIdByMbrLabelId(Long sysBrandId, Long mbrLabelId, String wxqyTagId);

    ResponseData<String> deleteByWxqyCorpTagId(Long sysBrandId, String wxqyTagId);

    ResponseData<String> deleteByMbrLabelGroupId(Long sysBrandId, Long mbrLabelGroupId);

    ResponseData<MbrLabelDefPO> getMemberLabelDefById(Long mbrLabelDefId);

    ResponseData<List<MbrLabelDefPO>> getMemberLabelDefByIdList(List<Long> mbrLabelDefIdList);

    ResponseData<List<MbrLabelDefPO>> getMemberLabelDefByLabelCodeList(GetMbrLabelListByCodeAndNameVO vo);

    ResponseData<List<MbrLabelDefPO>> getMemberLabelDefBySysBrandId(Long sysBrandId);

    ResponseData<List<MbrLabelDefPO>> getMemberLabelDefByMbrLabelGroupId(Long mbrLabelGroupId);

    ResponseData<String> syncMbrLabelById(Long mbrLabelDefId);

    ResponseData<List<MbrLabelDefPO>> getMbrLabelTypeByTagIdList(Long sysBrandId, List<String> wxqyTagIdList);

    // ResponseData<String> updateSyncStatusByMbrLabelIdList(Long sysBrandId, List<Long> mbrLabelDefIdList);

    /**
     * 获取会员所有标签
     * @param sysCompanyId
     * @param brandId
     * @param memberCode
     * @return
     */
    ResponseData<Map<String, List<Object>>> getMemberAllLabels(Long sysCompanyId, Long brandId, String memberCode);

    /**
     * 更新官方标签会员数
     * @param mbrLabelDefId
     * @param sysAccountPo
     * @return
     */
    ResponseData<Boolean> updateLabelMemberNum(Long mbrLabelDefId, SysAccountPO sysAccountPo);

}
