package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class StatisticsMemberConsumeVo implements Serializable {
    private static final long serialVersionUID = 1510685348233274298L;

    @ApiModelProperty(value = "sysCompanyId", name = "sysCompanyId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "memberCode", name = "memberCode")
    private String memberCode;

    @ApiModelProperty(value = "累计消费金额", name = "consumeAmountAll")
    private BigDecimal consumeAmountAll;

    @ApiModelProperty(value = "累计消费次数", name = "consumeNumberAll")
    private Integer consumeNumberAll;

    @ApiModelProperty(value = "累计消费件数", name = "consumeNumber")
    private Integer consumeNumber;

    @ApiModelProperty(value = "累计退款金额", name = "refundAmountAll")
    private BigDecimal refundAmountAll;

    @ApiModelProperty(value = "累计退款次数", name = "refundNumberAll")
    private Integer refundNumberAll;

    @ApiModelProperty(value = "消费折扣", name = "consumeDiscount")
    private Integer consumeDiscount;

    @ApiModelProperty(value = "件单价", name = "price")
    private BigDecimal price;

    @ApiModelProperty(value = "连带率", name = "aprNumberAll")
    private BigDecimal aprNumberAll;

    @ApiModelProperty(value = "客单价", name = "pctAmountAll")
    private BigDecimal pctAmountAll;

    @ApiModelProperty(value = "最高单笔", name = "highestNumber")
    private BigDecimal highestNumber;

    @ApiModelProperty(value = "最近一次消费时间", name = "lastBuyTime")
    private Date lastBuyTime;

    @ApiModelProperty(value = "最近一次消费门店Id", name = "lastBuyStoreId")
    private Long lastBuyStoreId;

    @ApiModelProperty(value = "最近一次消费门店code", name = "lastBuyStoreCode")
    private String lastBuyStoreCode;

    @ApiModelProperty(value = "最近一次消费门店名称", name = "lastBuyStoreName")
    private String lastBuyStoreName;

}
