package com.bizvane.members.facade.utils;

import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.SearchLabelRequest;
import com.bizvane.members.facade.es.vo.SearchRangRequest;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.wechatenterprise.service.common.DateUtil;
import io.jsonwebtoken.lang.Collections;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

/**
 * @author yuantq
 * @date 2023/3/13
 */
@Slf4j
public class MemberConditionUtil {

    private static Pattern pattern = Pattern.compile("^-?[0-9]+");

    /**
     * 验证会员是否满足条件(条件JSON为空时，则满足)
     * @param memberInfoModel
     * @param membersInfoSearchVo
     * @return
     */
    public static Boolean checkMemberCondition(MemberInfoModel memberInfoModel, MembersInfoSearchVo membersInfoSearchVo){
        //生日搜索判断
        if (membersInfoSearchVo.getBirthdayMdRange() != null) {
            List<SearchRangRequest> rangeList = membersInfoSearchVo.getBirthdayMdRange().getRange();
            if (membersInfoSearchVo.getBirthdayMdRange().getType() == 1) {
                if(StringUtils.isNotBlank(memberInfoModel.getBirthdayMd())){
                    for (SearchRangRequest birthdayMd : rangeList) {
                        if (zeroFill(birthdayMd.getMin()).compareTo(zeroFill(birthdayMd.getMax())) > 0) {
                            if(memberInfoModel.getBirthdayMd().compareTo(zeroFill(birthdayMd.getMin())) >= 0
                                    && memberInfoModel.getBirthdayMd().compareTo("1231") <= 0){
                                log.info("生日在{}~1231之间",zeroFill(birthdayMd.getMin()));
                                return Boolean.TRUE;
                            }
                            if(memberInfoModel.getBirthdayMd().compareTo("0101") >= 0
                                    && memberInfoModel.getBirthdayMd().compareTo(zeroFill(birthdayMd.getMax())) <= 0){
                                log.info("生日在0101~{}之间",zeroFill(birthdayMd.getMax()));
                                return Boolean.TRUE;
                            }
                        } else {
                            if(memberInfoModel.getBirthdayMd().compareTo(zeroFill(birthdayMd.getMin())) >= 0
                                    && memberInfoModel.getBirthdayMd().compareTo(zeroFill(birthdayMd.getMax())) <= 0){
                                log.info("生日在{}~{}之间",zeroFill(birthdayMd.getMin()),zeroFill(birthdayMd.getMax()));
                                return Boolean.TRUE;
                            }
                        }
                    }
                }else{
                    log.info("1-会员生日MD为空");
                }
            } else if (membersInfoSearchVo.getBirthdayMdRange().getType() == 2) {
                //固定时间段
                SimpleDateFormat mmDdFormat = new SimpleDateFormat("MMdd");
                if(StringUtils.isNotBlank(memberInfoModel.getBirthdayMd())){
                    for (SearchRangRequest birthdayMd : rangeList) {
                        String min = mmDdFormat.format(DateUtil.addDay(new Date(), Integer.parseInt(birthdayMd.getMin())));
                        String max = mmDdFormat.format(DateUtil.addDay(new Date(), Integer.parseInt(birthdayMd.getMax())));
                        if (min.compareTo(max) > 0) {
                            if(memberInfoModel.getBirthdayMd().compareTo(min) >= 0 && memberInfoModel.getBirthdayMd().compareTo("1231") <= 0){
                                return Boolean.TRUE;
                            }
                            if(memberInfoModel.getBirthdayMd().compareTo("0101") >= 0 && memberInfoModel.getBirthdayMd().compareTo(max) <= 0){
                                return Boolean.TRUE;
                            }
                        } else {
                            if(memberInfoModel.getBirthdayMd().compareTo(min) >= 0 && memberInfoModel.getBirthdayMd().compareTo(max) <= 0){
                                return Boolean.TRUE;
                            }
                        }
                    }
                }else{
                    log.info("2-会员生日MD为空");
                }

            }
        }
        //等级
        if (!Collections.isEmpty(membersInfoSearchVo.getLevelID())) {
            if(null != memberInfoModel.getLevelId()){
                if(membersInfoSearchVo.getLevelID().contains(memberInfoModel.getLevelId())){
                    log.info("满足等级:{}",memberInfoModel.getLevelId());
                    return Boolean.TRUE;
                }
            }else{
                log.info("会员等级ID为空");
            }
        }
        //官方标签
        if (null != membersInfoSearchVo.getLabels()) {
            String memberLabelIdStr = memberInfoModel.getLabelIds();
            List<String> labelIds = null;
            if (StringUtils.isNotBlank(memberLabelIdStr)){
                labelIds = Arrays.asList(memberLabelIdStr.split("-"));
            }
            if(!Collections.isEmpty(labelIds)){
                for(List<SearchLabelRequest> searchLabelRequests: membersInfoSearchVo.getLabels().getList()){
                    for(SearchLabelRequest searchLabelRequest:searchLabelRequests){
                        try{
                            if(labelIds.contains(searchLabelRequest.getMbrLabelDefId().toString())){
                                log.info("满足标签:{}-{}",searchLabelRequest.getMbrLabelDefId(),searchLabelRequest.getLabelName());
                                return Boolean.TRUE;
                            }
                        }catch(Exception e) {
                            log.error("验证标签异常-不影响主流程:{}", ExceptionUtils.getStackTrace(e));
                        }
                    }
                }
            }
        }
        //可用积分
        if (!Collections.isEmpty(membersInfoSearchVo.getIntegral())) {
            for(SearchRangRequest integral : membersInfoSearchVo.getIntegral()){
                if(null != memberInfoModel.getCountIntegral()){
                    if(StringUtils.isNotBlank(integral.getMin()) && StringUtils.isNotBlank(integral.getMax())){
                        try{
                            if(memberInfoModel.getCountIntegral() >= Integer.valueOf(integral.getMin())
                                    && memberInfoModel.getCountIntegral() <= Integer.valueOf(integral.getMax())){
                                log.info("可用积分满足在{}~{}范围条件",integral.getMin(),integral.getMax());
                                return Boolean.TRUE;
                            }
                        }catch (Exception e){
                            log.error("可用积分范围转换异常,不影响主流程:{}",ExceptionUtils.getStackTrace(e));
                        }
                    }else if(StringUtils.isNotBlank(integral.getMin()) && StringUtils.isBlank(integral.getMax())){
                        try{
                            if(memberInfoModel.getCountIntegral() >= Integer.valueOf(integral.getMin())){
                                log.info("可用积分满足大于{}条件",integral.getMin());
                                return Boolean.TRUE;
                            }
                        }catch (Exception e){
                            log.error("可用积分大于转换异常,不影响主流程:{}",ExceptionUtils.getStackTrace(e));
                        }
                    }else if(StringUtils.isBlank(integral.getMin()) && StringUtils.isNotBlank(integral.getMax())){
                        try{
                            if(memberInfoModel.getCountIntegral() <= Integer.valueOf(integral.getMax())){
                                log.info("可用积分满足小于{}条件",integral.getMax());
                                return Boolean.TRUE;
                            }
                        }catch (Exception e){
                            log.error("可用积分小于转换异常,不影响主流程:{}",ExceptionUtils.getStackTrace(e));
                        }
                    }
                }else{
                    log.info("会员可用积分为空");
                }
            }
        }
        //即将过期积分
        if (!Collections.isEmpty(membersInfoSearchVo.getAboutExpireIntegral())) {
            if(null != memberInfoModel.getExpiringIntegral()){
                for(SearchRangRequest expiringIntegral : membersInfoSearchVo.getAboutExpireIntegral()){
                    if(StringUtils.isNotBlank(expiringIntegral.getMin()) && StringUtils.isNotBlank(expiringIntegral.getMax())){
                        try{
                            if(memberInfoModel.getExpiringIntegral() >= Integer.valueOf(expiringIntegral.getMin())
                                    && memberInfoModel.getExpiringIntegral() <= Integer.valueOf(expiringIntegral.getMax())){
                                log.info("即将过期积分满足在{}~{}范围条件",expiringIntegral.getMin(),expiringIntegral.getMax());
                                return Boolean.TRUE;
                            }
                        }catch (Exception e){
                            log.error("即将过期积分范围转换异常,不影响主流程:{}",ExceptionUtils.getStackTrace(e));
                        }
                    }else if(StringUtils.isNotBlank(expiringIntegral.getMin()) && StringUtils.isBlank(expiringIntegral.getMax())){
                        try{
                            if(memberInfoModel.getExpiringIntegral() >= Integer.valueOf(expiringIntegral.getMin())){
                                log.info("即将过期积分满足大于{}条件",expiringIntegral.getMin());
                                return Boolean.TRUE;
                            }
                        }catch (Exception e){
                            log.error("即将过期积分大于转换异常,不影响主流程:{}",ExceptionUtils.getStackTrace(e));
                        }
                    }else if(StringUtils.isBlank(expiringIntegral.getMin()) && StringUtils.isNotBlank(expiringIntegral.getMax())){
                        try{
                            if(memberInfoModel.getExpiringIntegral() <= Integer.valueOf(expiringIntegral.getMax())){
                                log.info("即将过期积分满足小于{}条件",expiringIntegral.getMax());
                                return Boolean.TRUE;
                            }
                        }catch (Exception e){
                            log.error("即将过期积分小于转换异常,不影响主流程:{}",ExceptionUtils.getStackTrace(e));
                        }
                    }

                }
            }else{
                log.info("会员即将过期积分为空");
            }
        }
        return Boolean.FALSE;
    }

    // 防止用户忘记输0,后台补零
    private static String zeroFill(String number) {
        if (isNum(number)) {
            if (number.length() == 1) {
                return new StringBuffer().append("0").append(number).toString();
            }
        }
        return number;
    }

    // 验证是否为数字
    private static boolean isNum(String str) {

        if (pattern.matcher(str).matches()) {
            // 数字
            return true;
        }
        // 非数字
        return false;
    }
}
