package com.bizvane.members.facade.service.qywxapi;

import java.util.List;
import java.util.Map;

import com.bizvane.members.facade.es.pojo.qywx.MemberFlagPojo;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.members.facade.vo.MembersFriendsWithStoreIdVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bizvane.members.facade.es.pojo.qywx.MembersFriendPojo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.qywx.MemberFriendsKeyQueryVo;
//import com.bizvane.members.facade.vo.qywx.MemberFriendsKeyQueryVo;
import com.bizvane.members.facade.vo.qywx.MembersFriendVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface WxMembersApiService {

	/**
	 * 更新会员备注
	 * 
	 * @param memberComment
	 * @param memberCode
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/saveAndUpdateMembersComment", method = RequestMethod.POST)
	public ResponseData<Integer> saveAndUpdateMembersComment(@RequestParam("memberComment") String memberComment,
			@RequestParam("memberCode") String memberCode);

	/**
	 * 获取新会员列表
	 * 
	 * @param membersFriendVo
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/getMembersList", method = RequestMethod.POST)
	public ResponseData<PageInfo<MembersFriendPojo>> getMembersList(@RequestBody MembersFriendVo membersFriendVo);

	/**
	 * 获取新会员列表排序
	 *
	 * @param membersFriendVo
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/getMembersListOrder", method = RequestMethod.POST)
	public ResponseData<PageInfo<MembersFriendPojo>> getMembersListOrder(@RequestBody MembersFriendVo membersFriendVo);


	/**
	 * 查询会员等级
	 * 
	 * @param brandId
	 * @return
	 */
	@RequestMapping(value = "/api/wxMembersApi/getLevelMap", method = RequestMethod.POST)
	public ResponseData<Map<Long, String>> getLevelMap(@RequestParam("brandId") Long brandId);

	@RequestMapping(value = "/api/wxMembersApi/updateMembersMark", method = RequestMethod.POST)
	public ResponseData<Integer> updateMembersMark(@RequestParam("mark") Integer mark,
			@RequestParam("memberCode") String memberCode);
	
	//根据条件查询会员信息
	@RequestMapping(value = "/api/wxMembersApi/getMemberFriendsWithMultiKeyWord", method = RequestMethod.POST)
	public ResponseData<MemberInfoModel> getMemberFriendsWithMultiKeyWord(
			@RequestBody MemberFriendsKeyQueryVo memberFriendsKeyQueryVo);



	@RequestMapping(value = "/api/wxMembersApi/getMemberCodeByStoreId",method = RequestMethod.POST)
	public ResponseData<List<String>> getMemberCodeByStoreId(@RequestParam("brandId") Long brandId,@RequestParam("companyId") Long companyId,@RequestParam("storeId") Long storeId);


	@RequestMapping(value = "/api/wxMembersApi/getMemberCodeListByStoreIdPageable", method = RequestMethod.POST)
	ResponseData<PageInfo<String>> getMemberCodeListByStoreIdPageable(@RequestBody @Valid MembersFriendsWithStoreIdVo membersFriendsWithStoreIdVo);
	
	@RequestMapping(value = "/api/wxMembersApi/updateUnionId",method = RequestMethod.POST)
    ResponseData<Boolean> updateUnionId(@Valid @NotEmpty @RequestParam("brandId") Long brandId, @RequestParam("memberCode") String memberCode, @NotBlank @RequestParam("unionId") String unionId, @RequestParam("oldUnionId") String oldUnionId);

	// 异步更新会员的服务导购
	@RequestMapping(value = "/api/asyncUpdateMemberWithFriends", method = RequestMethod.POST)
	ResponseData<Integer> asyncUpdateMemberWithFriends(@RequestBody @Valid MemberFlagPojo memberFlagPojo);

}
