package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.es.pojo.qywx.WxQyFriendsPojo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatenterprise.service.entity.vo.WxQyFriendsSearchVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface WxFriendsApiService {

    // 分页调用ES查询好友列表接口
    @RequestMapping(value = "/api/wxFriendsApi/getWxQyFriendsList", method = RequestMethod.POST)
    ResponseData<PageInfo<WxQyFriendsPojo>> getWxQyFriendsList(@RequestBody WxQyFriendsSearchVo wxQyFriendsSearchVo);

    @RequestMapping(value = "/api/getUnionIdByExternalUserIdOrPendingId", method = RequestMethod.POST)
    ResponseData<String> getUnionIdByExternalUserIdOrPendingId(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId, @RequestParam("externalUserId") String externalUserId, @RequestParam("pendingId") String pendingId);


}
