package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberLabelModel;
import com.bizvane.members.facade.models.MemberLabelTypeModel;
import com.bizvane.members.facade.models.po.MbrExtendPropertyPO;
import com.bizvane.members.facade.models.po.MbrLabelDefPO;
import com.bizvane.members.facade.vo.MemberExtendPropertyVO;
import com.bizvane.members.facade.vo.qywx.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Author: houkai
 * @Date: 2018/11/6 15:55
 * @Description:
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
@Api(value = "会员标签相关接口",tags = {"会员标签相关接口"})
public interface MemberLabelApiService {
    /**
     * 查询品牌下所有标签组
     *
     * @param brandId
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/memberLabel/queryLabelGroupList", method = RequestMethod.POST)
    ResponseData<List<MemberLabelTypeModel>> queryLabelGroupList(long brandId) throws MemberException;

    /**
     * 查询标签列表
     *
     * @param memberLabelVo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/memberLabel/queryLabelList", method = RequestMethod.POST)
    ResponseData<PageInfo<MemberLabelModel>> queryLabelList(@RequestBody MemberLabelVo memberLabelVo) throws MemberException;

    /**
     * 更新会员标签
     *
     * @param updateMemberLabelVo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/memberLabel/updateMemberLabelVo", method = RequestMethod.POST)
    ResponseData updateMemberLabelVo(@RequestBody UpdateMemberLabelVo updateMemberLabelVo) throws MemberException;
    
    @ApiOperation(value = "查询热门标签")
    @RequestMapping(value = "/api/memberLabel/queryPopularLabelList", method = RequestMethod.POST)
    ResponseData<List<MbrLabelDefPO>> queryPopularLabelList(@RequestBody @Valid QueryPopularLabelListRequestVO requestVO);
    
    @ApiOperation(value = "查询官方标签")
    @RequestMapping(value = "/api/memberLabel/queryOfficialLabelList", method = RequestMethod.POST)
    ResponseData<List<QueryOfficialLabelListResponseVO>> queryOfficialLabelList(@RequestBody @Valid QueryPopularLabelListRequestVO requestVO);
    
    @ApiOperation(value = "查询导购自定义标签")
    @RequestMapping(value = "/api/memberLabel/queryCustomizeLabelList", method = RequestMethod.POST)
    ResponseData<List<MbrLabelDefPO>> queryCustomizeLabelList(@RequestBody @Valid QueryCustomizeLabelListRequestVO requestVO);
    
    @ApiOperation(value = "添加自定义标签")
    @RequestMapping(value = "/api/memberLabel/addCustomizeLabel", method = RequestMethod.POST)
    ResponseData<Object> addCustomizeLabel(@RequestBody @Valid AddCustomizeLabelRequestVO requestVO);
    
    @ApiOperation(value = "删除自定义标签")
    @RequestMapping(value = "/api/memberLabel/deleteCustomizeLabel", method = RequestMethod.POST)
    ResponseData<Object> deleteCustomizeLabel(@RequestBody @Valid DeleteCustomizeLabelRequestVO requestVO);

    @ApiOperation(value = "判断标签是否可以删除")
    @RequestMapping(value = "/api/memberLabel/judgeDeleteLabel", method = RequestMethod.POST)
    ResponseData<Boolean> judgeDeleteLabel(@RequestParam("labelId") @Valid Long labelId);

    @ApiOperation(value = "查询会员自动化标签")
    @RequestMapping(value = "/api/memberLabel/getAutoLabelList", method = RequestMethod.POST)
    ResponseData<MbrExtendPropertyPO> getAutoLabelList(@RequestParam("phone") String phone, @RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId);

    @ApiOperation(value = "根据标签id查询标签列表")
    @RequestMapping(value = "/api/memberLabel/getOfficialMbrLabelDefListByIdList", method = RequestMethod.POST)
    ResponseData<List<MbrLabelDefPO>> getOfficialMbrLabelDefListByIdList(@RequestParam("mbrLabelDefIdList") List<Long> mbrLabelDefIdList);
}
