package com.bizvane.members.facade.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * @Author: houkai
 * @Date: 2018/8/2 11:07
 * @Description:分组分析枚举
 */
public enum GroupAnalyzeEnum {

    /**
     * 分组分析统计维度 地域分析
     */
    TERRITORY("1", "地域分析"),
    /**
     * 分组分析统计维度 年龄分布
     */
    AGE("2", "年龄分布"),
    /**
     * 分组分析统计维度 等级分布
     */
    LEVEL("3", "等级分布"),

    /**
     * 分组分析统计维度 生日分布
     */
    BRITHDAY("5", "生日分布"),
    /**
     * 分组分析统计维度 性别分布
     */
    GENDER("6", "性别分布"),
    /**
     * 分组分析统计维度 新老会员
     */
    NEW_OLD("7", "新老会员"),
    /**
     * 分组分析统计维度 活跃度分布
     */
    LIVENESS("8", "活跃度分布"),
    /**
     * 分组分析统计维度 累计消费金额
     */
    CUMULATIVE("9", "累计消费金额"),
    /**
     * 分组分析统计维度 品类偏好
     */
    CATEGORY("10", "品类偏好");

//    SPECIES("11", "种类偏好"),
//
//    SUBCLASS("12", "小类偏好"),
//
//    DISCOUNT("13", "折扣分布"),
//
//    PER_CUSTOMER_TRANSACTION("14", "客单价分布"),
//
//    CONSUMPTION_FREQUENCY("15", "消费频次分布");

    private String code;

    private String msg;

    GroupAnalyzeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getGroupAnalyzeMessage(String code) {
        for (GroupAnalyzeEnum analyzeEnum : GroupAnalyzeEnum.values()) {
            if (code.equals(analyzeEnum.getCode())) {
                return analyzeEnum.getMsg();
            }
        }
        return "";
    }

    /**
     * 根据枚举code获得枚举
     *
     * @param code
     * @return
     */
    public static GroupAnalyzeEnum getGroupAnalyzeEnum(String code) {
        for (GroupAnalyzeEnum type : GroupAnalyzeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    /**
     * 将该枚举全部转化成json
     *
     * @return
     */
    public static JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        for (GroupAnalyzeEnum e : GroupAnalyzeEnum.values()) {
            JSONObject object = new JSONObject();
            object.put("typeId", e.getCode());
            object.put("typeName", e.getMsg());
            jsonArray.add(object);
        }
        return jsonArray;
    }
}
