package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.po.MbrLabelDefPO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/13.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MemberInfoVo extends MemberInfoModel {

    @ApiModelProperty(value = "扩展属性列表", name = "extendPropertyList")
    private List<ExtendPropertyValueVO> extendPropertyList;

    @ApiModelProperty(value = "会员所属门店编号", name = "memberStoreCode")
    private String memberStoreCode;

    @ApiModelProperty(value = "会员所属门店", name = "memberStoreName")
    private String memberStoreName;

    @ApiModelProperty(value = "会员所属导购工号", name = "memberGuideCode")
    private String memberGuideCode;

    @ApiModelProperty(value = "会员所属导购", name = "memberGuideName")
    private String memberGuideName;

    @ApiModelProperty(value = "会员所属群组编号", name = "memberStoreGroupCode")
    private String memberStoreGroupCode;

    @ApiModelProperty(value = "会员所属群组", name = "memberStoreGroupName")
    private String memberStoreGroupName;

    @ApiModelProperty(value = "会员所属品牌", name = "brandName")
    private String brandName;

    @ApiModelProperty(value = "微信昵称", name = "wxNick")
    private String wxNick;

    @ApiModelProperty(value = "是否关注,1：未关注,2：已关注", name = "focus", example = "是否关注,1：未关注,2：已关注")
    private Integer focus;

    @ApiModelProperty(value = "会员标签",name = "labelNames")
    private String labelNames;

    @ApiModelProperty(value = "是否具有品牌邮箱配置",name = "isBrandEmailConfig")
    private Boolean isBrandEmailConfig;

    @ApiModelProperty(value = "所属门店城市", name = "storeCityName")
    private String storeCityName;

    @ApiModelProperty(value = "所属门店区域", name = "storeAreaName")
    private String storeAreaName;

    @ApiModelProperty(value = "会员成长值",name = "growthNum")
    private Integer growthNum;

    @ApiModelProperty(value = "会员开卡门店code", name = "openServiceCode")
    private String openStoreCode;

    @ApiModelProperty(value = "会员开卡门店名称", name = "openServiceName")
    private String openStoreName;

    @ApiModelProperty(value = "最近购买时间", name = "lastBuyTime")
    private Date lastBuyTime;

    @ApiModelProperty(value = "打标签时间", name = "labelCreateTime")
    private String labelCreateTime;

    @ApiModelProperty(value = "标签详情", name = "labelList")
    private List<MbrLabelDefPO> labelList;

    @ApiModelProperty(value = "新官方标签名称（重复标签带分组名）", name = "newLabelNames")
    private String newLabelNames;
    
    @ApiModelProperty(value = "即将到期积分", name = "aboutExpireIntegral", example = "即将到期积分")
    private Integer aboutExpireIntegral;

    @ApiModelProperty(value = "即将到期时间", name = "aboutExpireTime", example = "即将到期时间")
    private Date aboutExpireTime;

}
