package com.bizvane.members.facade.vo.qywx;

import com.bizvane.members.facade.models.qywx.EsMbrFriendsModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
 * @author baofeng@bizvane.cn
 * @createTime 2022-11-08 14:23:42
 * @description: 好友列表查询对象
 */
@ApiModel(value = "好友列表查询对象")
@Getter
@Setter
public class EsMbrFriendListRequestVO extends EsMbrFriendsModel {

    @ApiModelProperty(name = "memberCodeList", value = "会员Code列表", required = false, example = "")
    private List<String> memberCodeList;

    @ApiModelProperty(name = "sysStaffIdList", value = "导购ID列表", required = false, example = "")
    private List<Long> sysStaffIdList;

    @ApiModelProperty(name = "excludeExternalUserIdList", value = "排除掉的外部联系人UserID列表", required = false, example = "")
    private List<String> excludeExternalUserIdList;

    @ApiModelProperty(name = "friendStatus", value = "好友状态：0正常 1导购离职待分配 2重新分配待确认(无效状态) 3:删除 4:在职待分配 5:离职分配待确认 6:在职分配待确认", required = false, example = "")
    private Integer friendStatus;

    @ApiModelProperty(name = "exclusiveFriend", value = "是否专属好友：1是，0否", required = false, example = "")
    private Integer exclusiveFriend;

    @ApiModelProperty(name = "addFriendStartDate", value = "加好友开始时间", required = false, example = "")
    private Date addFriendStartDate;

    @ApiModelProperty(name = "addFriendEndDate", value = "加好友结束时间", required = false, example = "")
    private Date addFriendEndDate;

    @ApiModelProperty(name = "friendDistinct", value = "是否去重：1-是，0-否", required = true)
    private Integer friendDistinct;

    private Integer pageNumber = 1;

    private Integer pageSize = 10;

}
