/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.utils;

import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.SearchLabelRequest;
import com.bizvane.members.facade.es.vo.SearchRangRequest;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.wechatenterprise.service.common.DateUtil;
import io.jsonwebtoken.lang.Collections;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberConditionUtil {
    private static final Logger log = LoggerFactory.getLogger(MemberConditionUtil.class);
    private static Pattern pattern = Pattern.compile("^-?[0-9]+");

    public static Boolean checkMemberCondition(MemberInfoModel memberInfoModel, MembersInfoSearchVo membersInfoSearchVo) {
        if (membersInfoSearchVo.getBirthdayMdRange() != null) {
            List<SearchRangRequest> rangeList = membersInfoSearchVo.getBirthdayMdRange().getRange();
            if (membersInfoSearchVo.getBirthdayMdRange().getType() == 1) {
                if (StringUtils.isNotBlank((CharSequence)memberInfoModel.getBirthdayMd())) {
                    for (SearchRangRequest searchRangRequest : rangeList) {
                        if (MemberConditionUtil.zeroFill(searchRangRequest.getMin()).compareTo(MemberConditionUtil.zeroFill(searchRangRequest.getMax())) > 0) {
                            if (memberInfoModel.getBirthdayMd().compareTo(MemberConditionUtil.zeroFill(searchRangRequest.getMin())) >= 0 && memberInfoModel.getBirthdayMd().compareTo("1231") <= 0) {
                                log.info("\u751f\u65e5\u5728{}~1231\u4e4b\u95f4", (Object)MemberConditionUtil.zeroFill(searchRangRequest.getMin()));
                                return Boolean.TRUE;
                            }
                            if (memberInfoModel.getBirthdayMd().compareTo("0101") < 0 || memberInfoModel.getBirthdayMd().compareTo(MemberConditionUtil.zeroFill(searchRangRequest.getMax())) > 0) continue;
                            log.info("\u751f\u65e5\u57280101~{}\u4e4b\u95f4", (Object)MemberConditionUtil.zeroFill(searchRangRequest.getMax()));
                            return Boolean.TRUE;
                        }
                        if (memberInfoModel.getBirthdayMd().compareTo(MemberConditionUtil.zeroFill(searchRangRequest.getMin())) < 0 || memberInfoModel.getBirthdayMd().compareTo(MemberConditionUtil.zeroFill(searchRangRequest.getMax())) > 0) continue;
                        log.info("\u751f\u65e5\u5728{}~{}\u4e4b\u95f4", (Object)MemberConditionUtil.zeroFill(searchRangRequest.getMin()), (Object)MemberConditionUtil.zeroFill(searchRangRequest.getMax()));
                        return Boolean.TRUE;
                    }
                } else {
                    log.info("1-\u4f1a\u5458\u751f\u65e5MD\u4e3a\u7a7a");
                }
            } else if (membersInfoSearchVo.getBirthdayMdRange().getType() == 2) {
                SimpleDateFormat mmDdFormat = new SimpleDateFormat("MMdd");
                if (StringUtils.isNotBlank((CharSequence)memberInfoModel.getBirthdayMd())) {
                    for (SearchRangRequest searchRangRequest : rangeList) {
                        String max;
                        String min = mmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt(searchRangRequest.getMin())));
                        if (min.compareTo(max = mmDdFormat.format(DateUtil.addDay((Date)new Date(), (int)Integer.parseInt(searchRangRequest.getMax())))) > 0) {
                            if (memberInfoModel.getBirthdayMd().compareTo(min) >= 0 && memberInfoModel.getBirthdayMd().compareTo("1231") <= 0) {
                                return Boolean.TRUE;
                            }
                            if (memberInfoModel.getBirthdayMd().compareTo("0101") < 0 || memberInfoModel.getBirthdayMd().compareTo(max) > 0) continue;
                            return Boolean.TRUE;
                        }
                        if (memberInfoModel.getBirthdayMd().compareTo(min) < 0 || memberInfoModel.getBirthdayMd().compareTo(max) > 0) continue;
                        return Boolean.TRUE;
                    }
                } else {
                    log.info("2-\u4f1a\u5458\u751f\u65e5MD\u4e3a\u7a7a");
                }
            }
        }
        if (!Collections.isEmpty(membersInfoSearchVo.getLevelID())) {
            if (null != memberInfoModel.getLevelId()) {
                if (membersInfoSearchVo.getLevelID().contains(memberInfoModel.getLevelId())) {
                    log.info("\u6ee1\u8db3\u7b49\u7ea7:{}", (Object)memberInfoModel.getLevelId());
                    return Boolean.TRUE;
                }
            } else {
                log.info("\u4f1a\u5458\u7b49\u7ea7ID\u4e3a\u7a7a");
            }
        }
        if (null != membersInfoSearchVo.getLabels()) {
            String memberLabelIdStr = memberInfoModel.getLabelIds();
            List<String> labelIds = null;
            if (StringUtils.isNotBlank((CharSequence)memberLabelIdStr)) {
                labelIds = Arrays.asList(memberLabelIdStr.split("-"));
            }
            if (!Collections.isEmpty(labelIds)) {
                for (List<SearchLabelRequest> list : membersInfoSearchVo.getLabels().getList()) {
                    for (SearchLabelRequest searchLabelRequest : list) {
                        try {
                            if (!labelIds.contains(searchLabelRequest.getMbrLabelDefId().toString())) continue;
                            log.info("\u6ee1\u8db3\u6807\u7b7e:{}-{}", (Object)searchLabelRequest.getMbrLabelDefId(), (Object)searchLabelRequest.getLabelName());
                            return Boolean.TRUE;
                        }
                        catch (Exception e) {
                            log.error("\u9a8c\u8bc1\u6807\u7b7e\u5f02\u5e38-\u4e0d\u5f71\u54cd\u4e3b\u6d41\u7a0b:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                        }
                    }
                }
            }
        }
        if (!Collections.isEmpty(membersInfoSearchVo.getIntegral())) {
            for (SearchRangRequest integral : membersInfoSearchVo.getIntegral()) {
                if (null != memberInfoModel.getCountIntegral()) {
                    if (StringUtils.isNotBlank((CharSequence)integral.getMin()) && StringUtils.isNotBlank((CharSequence)integral.getMax())) {
                        try {
                            if (memberInfoModel.getCountIntegral() < Integer.valueOf(integral.getMin()) || memberInfoModel.getCountIntegral() > Integer.valueOf(integral.getMax())) continue;
                            log.info("\u53ef\u7528\u79ef\u5206\u6ee1\u8db3\u5728{}~{}\u8303\u56f4\u6761\u4ef6", (Object)integral.getMin(), (Object)integral.getMax());
                            return Boolean.TRUE;
                        }
                        catch (Exception exception) {
                            log.error("\u53ef\u7528\u79ef\u5206\u8303\u56f4\u8f6c\u6362\u5f02\u5e38,\u4e0d\u5f71\u54cd\u4e3b\u6d41\u7a0b:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
                            continue;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)integral.getMin()) && StringUtils.isBlank((CharSequence)integral.getMax())) {
                        try {
                            if (memberInfoModel.getCountIntegral() < Integer.valueOf(integral.getMin())) continue;
                            log.info("\u53ef\u7528\u79ef\u5206\u6ee1\u8db3\u5927\u4e8e{}\u6761\u4ef6", (Object)integral.getMin());
                            return Boolean.TRUE;
                        }
                        catch (Exception exception) {
                            log.error("\u53ef\u7528\u79ef\u5206\u5927\u4e8e\u8f6c\u6362\u5f02\u5e38,\u4e0d\u5f71\u54cd\u4e3b\u6d41\u7a0b:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
                            continue;
                        }
                    }
                    if (!StringUtils.isBlank((CharSequence)integral.getMin()) || !StringUtils.isNotBlank((CharSequence)integral.getMax())) continue;
                    try {
                        if (memberInfoModel.getCountIntegral() > Integer.valueOf(integral.getMax())) continue;
                        log.info("\u53ef\u7528\u79ef\u5206\u6ee1\u8db3\u5c0f\u4e8e{}\u6761\u4ef6", (Object)integral.getMax());
                        return Boolean.TRUE;
                    }
                    catch (Exception exception) {
                        log.error("\u53ef\u7528\u79ef\u5206\u5c0f\u4e8e\u8f6c\u6362\u5f02\u5e38,\u4e0d\u5f71\u54cd\u4e3b\u6d41\u7a0b:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
                        continue;
                    }
                }
                log.info("\u4f1a\u5458\u53ef\u7528\u79ef\u5206\u4e3a\u7a7a");
            }
        }
        if (!Collections.isEmpty(membersInfoSearchVo.getAboutExpireIntegral())) {
            if (null != memberInfoModel.getExpiringIntegral()) {
                for (SearchRangRequest expiringIntegral : membersInfoSearchVo.getAboutExpireIntegral()) {
                    if (StringUtils.isNotBlank((CharSequence)expiringIntegral.getMin()) && StringUtils.isNotBlank((CharSequence)expiringIntegral.getMax())) {
                        try {
                            if (memberInfoModel.getExpiringIntegral() < Integer.valueOf(expiringIntegral.getMin()) || memberInfoModel.getExpiringIntegral() > Integer.valueOf(expiringIntegral.getMax())) continue;
                            log.info("\u5373\u5c06\u8fc7\u671f\u79ef\u5206\u6ee1\u8db3\u5728{}~{}\u8303\u56f4\u6761\u4ef6", (Object)expiringIntegral.getMin(), (Object)expiringIntegral.getMax());
                            return Boolean.TRUE;
                        }
                        catch (Exception exception) {
                            log.error("\u5373\u5c06\u8fc7\u671f\u79ef\u5206\u8303\u56f4\u8f6c\u6362\u5f02\u5e38,\u4e0d\u5f71\u54cd\u4e3b\u6d41\u7a0b:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
                            continue;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)expiringIntegral.getMin()) && StringUtils.isBlank((CharSequence)expiringIntegral.getMax())) {
                        try {
                            if (memberInfoModel.getExpiringIntegral() < Integer.valueOf(expiringIntegral.getMin())) continue;
                            log.info("\u5373\u5c06\u8fc7\u671f\u79ef\u5206\u6ee1\u8db3\u5927\u4e8e{}\u6761\u4ef6", (Object)expiringIntegral.getMin());
                            return Boolean.TRUE;
                        }
                        catch (Exception exception) {
                            log.error("\u5373\u5c06\u8fc7\u671f\u79ef\u5206\u5927\u4e8e\u8f6c\u6362\u5f02\u5e38,\u4e0d\u5f71\u54cd\u4e3b\u6d41\u7a0b:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
                            continue;
                        }
                    }
                    if (!StringUtils.isBlank((CharSequence)expiringIntegral.getMin()) || !StringUtils.isNotBlank((CharSequence)expiringIntegral.getMax())) continue;
                    try {
                        if (memberInfoModel.getExpiringIntegral() > Integer.valueOf(expiringIntegral.getMax())) continue;
                        log.info("\u5373\u5c06\u8fc7\u671f\u79ef\u5206\u6ee1\u8db3\u5c0f\u4e8e{}\u6761\u4ef6", (Object)expiringIntegral.getMax());
                        return Boolean.TRUE;
                    }
                    catch (Exception exception) {
                        log.error("\u5373\u5c06\u8fc7\u671f\u79ef\u5206\u5c0f\u4e8e\u8f6c\u6362\u5f02\u5e38,\u4e0d\u5f71\u54cd\u4e3b\u6d41\u7a0b:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
                    }
                }
            } else {
                log.info("\u4f1a\u5458\u5373\u5c06\u8fc7\u671f\u79ef\u5206\u4e3a\u7a7a");
            }
        }
        return Boolean.FALSE;
    }

    private static String zeroFill(String number) {
        if (MemberConditionUtil.isNum(number) && number.length() == 1) {
            return new StringBuffer().append("0").append(number).toString();
        }
        return number;
    }

    private static boolean isNum(String str) {
        return pattern.matcher(str).matches();
    }
}

