package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.vo.qywx.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatenterprise.service.entity.vo.ShareGoodsAchieveDetailResponseVO;
import com.bizvane.wechatenterprise.service.entity.vo.ShareGoodsAchieveResponseVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MbrMallShareApiService {

    /**
     * 商品秀导购【我分享的】tab页分页列表
     *
     * @param req 请求条件对象
     * @return 分页列表结果
     */
    @PostMapping(value = "/api/mallShare/record/pageList")
    ResponseData<PageInfo<MallShareRecordListResponseVO>> pageListRecord(@RequestBody @Valid MallShareRecordListRequestVO req);

    /**
     * 商品秀导购【分享业绩】tab页统计接口
     *
     * @param req 请求条件对象
     * @return 业绩统计结果
     */
    @PostMapping(value = "/api/mallShare/queryAchievement")
    ResponseData<MallShareAchievementResponseVO> queryAchievement(@RequestBody @Valid MallShareAchievementRequestVO req);

    /**
     * 商品秀导购【分享订单】tab页分页列表
     *
     * @param req 请求条件对象
     * @return 分页列表结果
     */
    @PostMapping(value = "/api/mallShare/order/pageList")
    ResponseData<PageInfo<MallShareOrderListResponseVO>> pageListOrder(@RequestBody @Valid MallShareOrderListRequestVO req);

    /**
     * 中台【导购分享业绩】分页列表
     *
     * @param req 请求条件对象
     * @return 分页列表结果
     */
    @PostMapping(value = "/api/mallShare/staff/pageList")
    ResponseData<PageInfo<ShareGoodsAchieveResponseVO>> pageListStaff(@RequestBody @Valid MallShareStaffListRequestVO req);


    /**
     * 中台【导购分享业绩-导购对账单】分页列表
     *
     * @param req 请求条件对象
     * @return 分页列表结果
     */
    @PostMapping(value = "/api/mallShare/staffOrder/pageList")
    ResponseData<PageInfo<ShareGoodsAchieveDetailResponseVO>> pageListStaffOrder(@RequestBody @Valid MallShareStaffOrderListRequestVO req);

}
