package com.bizvane.members.facade.service.inner;

import java.util.Optional;

import com.bizvane.members.facade.es.pojo.qywx.WxQyFriendsPojo;
import com.bizvane.members.facade.es.vo.WxQyFriendsSearchVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.qywx.WxQyFriendsResponseVo;
import com.bizvane.members.facade.models.qywx.WxqyPendingParam;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

public interface WxQyFriendsService {
	ResponseData<PageInfo<WxQyFriendsPojo>> searchAdvanced(WxQyFriendsSearchVo searchVo);

	void updateFriendsWithMembers(MemberInfoModel memberInfoModel);

	void updateFriendsFocus(String unionId, Long brandId, Integer focus);
	
	ResponseData<PageInfo<WxQyFriendsResponseVo>> getWxQyFriendsList(WxQyFriendsSearchVo wxQyFriendsSearchVo,Optional<SysAccountPO> optional);

	ResponseData<String> exportWxQyFriends(WxQyFriendsSearchVo wxQyFriendsSearchVo, Optional<SysAccountPO> optional);

	ResponseData<PageInfo<WxQyFriendsPojo>> searchAdvancedApi(WxQyFriendsSearchVo searchVo);
	
  /**
   * 通过unionId判断是否是好友
   * @param unionId
   * @return
   */
  boolean checkIsFriend(Long sysCompanyId, Long sysBrandId, String unionId, String type);
  
  String getExternalUserId(Long sysCompanyId, Long sysBrandId, String unionId);
  
  String getUnionId(Long sysCompanyId, Long sysBrandId, String externalUserId, String pendingId);
  
  boolean  checkIsBindExternalUserId(WxqyPendingParam param);
}
