package com.bizvane.members.facade.service.common;

import com.bizvane.members.facade.models.MemberInfoUpdateResponseVO;
import com.bizvane.members.facade.models.StandardMemberPerfectRequestVo;
import com.bizvane.members.facade.models.po.MbrUniversalBindChannelPo;
import com.bizvane.members.facade.models.third.MemberThirdOpenCardRequestBO;
import com.bizvane.members.facade.vo.yanzhiwu.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface CommonMemberApiService {

    @PostMapping(value = "/api/yanzhiwu/openCard")
    ResponseData<MemberOpenCardResponseVo> openCard(@RequestBody @Valid MemberOpenCardRequestVo requestVo);
    
    @PostMapping(value = "/api/mbr/thirdOpenCard")
    ResponseData<MemberOpenCardResponseVo> thirdOpenCard(@RequestBody @Valid MemberThirdOpenCardRequestBO requestVo);

    @PostMapping(value = "/api/yanzhiwu/memberQuery")
    ResponseData<MemberQueryResponseVo> memberQuery(@RequestBody @Valid MemberQueryRequestVo requestVo);

    @PostMapping(value = "/api/yanzhiwu/memberPerfect")
    ResponseData<MemberInfoUpdateResponseVO> memberPerfect(@RequestBody @Valid StandardMemberPerfectRequestVo requestVo);

    @PostMapping(value = "/api/yanzhiwu/memberThirdBindChannel")
    ResponseData memberThirdBindChannel(@RequestBody @Valid MemberThirdBindChannelRequestVo requestVo);

    @PostMapping(value = "/api/yanzhiwu/memberUpdateChannelIds")
    ResponseData memberUpdateChannelIds(@RequestBody @Valid MemberUpdateChannelIdsReqVo requestVo);

    @PostMapping(value = "/api/yanzhiwu/queryMemberChannelRecord")
    ResponseData<Boolean> queryMemberChannelRecord(@RequestBody @Valid MemberQueryChannelRecordReqVo requestVo);
    
    @PostMapping(value = "/api/member/queryMbrUniversalBindChannel")
    ResponseData<MbrUniversalBindChannelPo> queryMbrUniversalBindChannel(@RequestBody @Valid MemberQueryChannelRecordReqVo requestVo);

}
