package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.bo.BatchInsertIntegralRecordBO;
import com.bizvane.members.facade.models.bo.BatchTaskBo;
import com.bizvane.members.facade.models.po.MbrIntegralBatchRecordPO;
import com.bizvane.members.facade.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

public interface MbrIntegralBatchRecordService {

    //批量插入要调整的积分记录(不处理积分扣减/增加)
    ResponseData<BatchInsertIntegralRecordBO> batchInsertIntegralRecordBeforeProcess(BatchUpdateMemberIntegralVO batchUpdateMemberIntegralVO,SysAccountPO sysAccountPo);

    //异步处理积分
    void asyncProcessIntegral(BatchInsertIntegralRecordBO batchInsertIntegralRecordBO);

    ResponseData<MbrIntegralBatchRecordPO> InsertIntegralRecordBeforeProcess(IntegralRecordModel integralRecordModel);

    ResponseData<BatchTaskBo> batchChangeIntegralTask(BatchMemberTaskVo batchMemberTaskVo, SysAccountPO sysAccountPo);


    void asyncBatchChangeIntegralTask(BatchMemberTaskVo batchMemberTaskVo, BatchTaskBo batchTaskBo);


    void asyncRetryChangeIntegralTask(BatchTaskBo batchTaskBo);


    void updateIntegralBatchRecordStatus(MbrIntegralBatchRecordPO batchInsertIntegralRecordBO, Integer changeStatus, String reason);

    ResponseData<BatchIntegralRecordResponseVO> selectBatchIntegralRecord(BatchIntegralRecordRequestVO batchIntegralRecordRequestVO, Long sysCompanyId, Long brandId);


    ResponseData<String> exportBatchIntegralRecord(BatchIntegralRecordRequestVO batchIntegralRecordRequestVO, SysAccountPO sysAccountPo);
    
    /**
     * 按订单重新加积分，主要用于下单时因异常情况没有参加活动的订单
     * 没有参数，需要提前把要处理的订单导入临时表
     * @return
     */
    int orderAddIntegral();


    ResponseData<String> importBatchIntegral(ImportBatchIntegralVO batchIntegralVO, SysAccountPO currentLoginUser);
}
