package com.bizvane.members.facade.models.bitdatacenter;

import lombok.Data;

import java.util.Objects;


/**
 * 大数据中心返回基本参数
 * @author huangxinliu
 * @date: 2021/1/28 17:39
 */
@Data
public class BitDataCenterResBasicDto<T> {

    private String successFlag;
    private String errorCode;
    private String message;
    private T data;

    /**
     * 请求是否成功
     * @return
     */
    public Boolean isSucc() {
        return Objects.nonNull(this.getSuccessFlag()) && SUCCESS_FLAG.equals(this.getSuccessFlag());
    }

    public static String SUCCESS_FLAG = "1";
    public static String FAIL_FLAG = "0";

    public static String FAIL_MSG_504 = "数据查询超时，请刷新页面后重试";

    public static BitDataCenterResBasicDto fail(String errMessage){
        BitDataCenterResBasicDto dto = new BitDataCenterResBasicDto();
        dto.setSuccessFlag(FAIL_FLAG);
        dto.setMessage(errMessage);
        return dto;
    }

}
