package com.bizvane.members.facade.service.electcard;

import javax.validation.Valid;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.vo.MemberElectCardQueryRequestVo;
import com.bizvane.members.facade.vo.MemberElectCardQueryResponseVo;
import com.bizvane.members.facade.vo.MemberElectCardRequestVo;
import com.bizvane.members.facade.vo.MemberElectCardResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberElectCardOpenCardApiService {

	@RequestMapping(value = "/api/memberElectCard/openCard", method = RequestMethod.POST)
	public ResponseData<MemberElectCardResponseVo> openCard(
			@RequestBody @Valid MemberElectCardRequestVo memberElectCardRequestVo) throws MemberException;

	@RequestMapping(value = "/api/memberElectCard/queryCard", method = RequestMethod.POST)
	public ResponseData<MemberElectCardQueryResponseVo> queryCard(
			@RequestBody @Valid MemberElectCardQueryRequestVo memberElectCardQueryRequestVo) throws MemberException;
}
