package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.models.MemberLabelTypeModel;
import com.bizvane.members.facade.models.po.MbrLabelDefPO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface MbrLabelServiceRpc {

    @PostMapping("/memberLabel/updateTagIdByMbrLabelId")
    ResponseData<String> updateTagIdByMbrLabelId(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("mbrLabelDefId")Long mbrLabelDefId, @RequestParam("wxqyTagId")String wxqyTagId);

    @PostMapping("/memberLabelGroup/updateTagGroupIdByMbrLabelGroupId")
    ResponseData<String> updateTagGroupIdByMbrLabelGroupId(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("mbrLabelGroupDefId")Long mbrLabelGroupDefId, @RequestParam("wxqyTagGroupId")String wxqyTagGroupId);

    @PostMapping("/memberLabelGroup/deleteByWxqyTagGroupId")
    ResponseData<String> deleteByWxqyTagGroupId(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("wxqyTagGroupId")String wxqyTagGroupId);

    @PostMapping("/memberLabel/deleteByWxqyCorpTagId")
    ResponseData<String> deleteByWxqyCorpTagId(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("wxqyTagId")String wxqyTagId);

    @PostMapping("/memberLabel/getMemberLabelDefById")
    ResponseData<MbrLabelDefPO> getMemberLabelDefById(@RequestParam("mbrLabelDefId")Long mbrLabelDefId);

    @PostMapping("/memberLabelGroup/getMbrLabelGroupById")
    ResponseData<MemberLabelTypeModel> getMbrLabelGroupById(@RequestParam("mbrLabelDefId")Long mbrLabelDefId);

    @PostMapping("/memberLabel/getMemberLabelDefByIdList")
    ResponseData<List<MbrLabelDefPO>> getMemberLabelDefByIdList(@RequestBody List<Long> mbrLabelDefIdList);

    @PostMapping("/memberLabelGroup/getMbrLabelGroupByIdList")
    ResponseData<List<MemberLabelTypeModel>> getMbrLabelGroupByIdList(@RequestBody List<Long> mbrLabelGroupIdList);
}
