package com.bizvane.members.facade.vo;

import com.sun.tracing.dtrace.ArgsAttributes;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 自动标签列表vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年11月03日 20:35:00
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AutoLabelListVo implements Serializable {

    /**
     * 自动标签名称
     */
    @ApiModelProperty(value = "自动标签名称", name = "name")
    @NotEmpty
    private String name;

    /**
     * 自动标签描述
     */
    @ApiModelProperty(value = "自动标签描述", name = "desc")
    private String description;

    /**
     * 自动标签更新周期
     */
    @ApiModelProperty(value = "自动标签更新周期", name = "cycleType")
    private Integer cycleType;

    /**
     * 更新日期
     */
    @ApiModelProperty(value = "最新更新时间", name = "modifyDate")
    private Date modifyDate;

    /**
     * 自动标签id
     */
    @ApiModelProperty(value = "自动标签id", name = "autoLabelId")
    private Long autoLabelId;

    /**
     * 打标人数
     */
    @ApiModelProperty(value = "打标人数", name = "targetCount")
    private Long targetCount;

    /**
     * 打标进度
     */
    @ApiModelProperty(value = "打标进度", name = "process")
    private Integer process;

    /**
     * 自动标签分组名称
     */
    @ApiModelProperty(value = "自动标签分组名称", name = "autoLabelGroupName")
    private String autoLabelGroupName;

    /**
     * 自动标签规则
     */
    @ApiModelProperty(value = "自动标签规则", name = "labelCondition")
    private String labelCondition;


    /**
     * 自动标签分组id
     */
    @ApiModelProperty(value = "自动标签分组id", name = "autoLabelGroupId")
    private Long autoLabelGroupId;

    /**
     * 自动标签状态 1 未计算 2 大数据计算中 3 计算完成 4 CRM写入中 5 写入完成
     */
    @ApiModelProperty(value = "自动标签状态", name = "status")
    private Integer status;

    /**
     * 是否开启状态 0-不开启 1-开启
     */
    @ApiModelProperty(value = "是否开启状态 0-不开启 1-开启", name = "openStatus")
    private Integer openStatus;

    /**
     * 标签36进制编码
     */
    @ApiModelProperty(value = "标签36进制编码", name = "labelCode")
    private String labelCode;

    /**
     * 线上运营组织编码
     */
    @ApiModelProperty(value = "线上运营组织编码", name = "onlineOrgCode")
    private String onlineOrgCode;



}
