package com.bizvane.members.facade.models;

import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class StandardMemberPerfectRequestVo {

    @NotNull
    private Long sysCompanyId;

    @NotNull
    private Long sysBrandId;

    /*
        请求来源:1.POS(门店) 2.官网3 4.微信 5.天猫 6.其他
     */
    @NotNull
    private String source;

    /*
        线下id
     */
    @NotNull
    private String erpId;

    /*
        服务门店
     */
    private String newServerStoreCode;

    /**
     * 服务导购
     */
    private String newServerGuideCode;

    /*
        会员姓名
     */
    private String newName;

    /*
        会员手机号
     */
    private String newPhone;

    /*
        会员性别（1女、2男、3，未知，默认未知）
     */
    private String newSex;

    /*
        省
     */
    private String newProvince;

    /*
        市
     */
    private String newCity;

    /*
        区
     */
    private String newCounty;

    /*
        会员详细地址
     */
    private String newAddress;

    /*
        备注
     */
    private String newRemark;

    /*
        会员邮箱
     */
    private String newEmail;

    /*
        会员身份证号
     */
    private String newIdCard;

    /*
        会员生日 格式：yyyy-MM-dd
     */
    private String newBirthday;

    /*
        会员卡状态1 有效 0无效
     */
    private String newValid;

    /*
        等级code
     */
    private String newLevelCode;

    /*
    * openId，配合source进行使用，目前主要使用：渠道是11(有赞)则是有赞openId
    * */
    private String openId;
}
