package com.bizvane.members.facade.service.card;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.vo.MemberCardStatusModifyBaseVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author zcc
 * @date 2021/8/3 14:09
 * 会员卡状态变更抽象方法
 **/
@Slf4j
@Component
public abstract class AbstractApiMemberCardStatusModifyService<T extends MemberCardStatusModifyBaseVo>{

    /**
     * 参数校验
     * @param memberCardStatusModifyVo
     * @return
     */
    public abstract ResponseData<String> validationData(T memberCardStatusModifyVo);

    /**
     * 会员卡表处理
      * @param memberCardStatusModifyVo
     */
    public abstract Boolean memberCardModify(T memberCardStatusModifyVo);

    /**
     * 微信渠道表处理
     * @param memberCardStatusModifyVo
     */
    public abstract Boolean memberChannelModify(T memberCardStatusModifyVo);

    /**
     * 电子会员卡表处理
     * @param memberCardStatusModifyVo
     */
    public abstract Boolean memberElectCardModify(T memberCardStatusModifyVo);

    /**
     * 会员对应线下erp处理
     * @param memberCardStatusModifyVo
     */
    public abstract Boolean memberToErpModify(T memberCardStatusModifyVo);

    /**
     * 日志收集
     * @param memberCardStatusModifyVo
     */
    public abstract Boolean addMbrCardStatusLog(T memberCardStatusModifyVo);

    /**
     * 需要处理异常
     * @param memberCardStatusModifyVo
     * @return
     * @throws RuntimeException
     */
    @Transactional(rollbackFor = Exception.class)
    protected ResponseData<String> standardMemberCardStatusModify(T memberCardStatusModifyVo) throws MemberException {
        log.info("memberCardStatusModify memberCardStatusModifyVo:{}", JacksonUtil.bean2Json(memberCardStatusModifyVo));
        //1.参数校验
        ResponseData<String> validationDataResponse = validationData(memberCardStatusModifyVo);
        if (SysResponseEnum.SUCCESS.getCode() != validationDataResponse.getCode()) {
            log.info("memberCardStatusModify memberCardStatusModifyVo 参数校验不通过,memberCardStatusModifyVo:{}", JacksonUtil.bean2Json(memberCardStatusModifyVo));
            return validationDataResponse;
        }
        //2.会员卡表处理
        log.info("会员卡表开始处理,memberCode:{}", memberCardStatusModifyVo.getMemberCode());
        if (!Boolean.TRUE.equals(memberCardModify(memberCardStatusModifyVo))) {
            log.info("memberCardStatusModify memberCardStatusModifyVo 会员卡表处理失败,memberCardStatusModifyVo:{}", JacksonUtil.bean2Json(memberCardStatusModifyVo));
            throw new MemberException("会员卡表处理失败");
        }
        //3.微信渠道表处理
        log.info("微信渠道表开始处理,memberCode:{}", memberCardStatusModifyVo.getMemberCode());
        if (!Boolean.TRUE.equals(memberChannelModify(memberCardStatusModifyVo))) {
            log.info("memberCardStatusModify memberCardStatusModifyVo 微信渠道表处理失败,memberCardStatusModifyVo:{}", JacksonUtil.bean2Json(memberCardStatusModifyVo));
            throw new MemberException("微信渠道表处理失败");
        }
        //4.电子会员卡表处理
        log.info("电子会员卡表开始处理,memberCode:{}", memberCardStatusModifyVo.getMemberCode());
        if (!Boolean.TRUE.equals(memberElectCardModify(memberCardStatusModifyVo))) {
            log.info("memberCardStatusModify memberCardStatusModifyVo 微信渠道表处理失败,memberCardStatusModifyVo:{}", JacksonUtil.bean2Json(memberCardStatusModifyVo));
            throw new MemberException("微信渠道表处理失败");
        }
        //5.会员对应线下erp处理
        log.info("会员对应线下erp开始处理,memberCode:{}", memberCardStatusModifyVo.getMemberCode());
        if (!Boolean.TRUE.equals(memberToErpModify(memberCardStatusModifyVo))) {
            log.info("memberCardStatusModify memberCardStatusModifyVo 会员对应线下erp处理失败,memberCardStatusModifyVo:{}", JacksonUtil.bean2Json(memberCardStatusModifyVo));
            throw new MemberException("会员对应线下erp处理失败");
        }
        //5.日志收集
        log.info("日志收集开始处理,memberCode:{}", memberCardStatusModifyVo.getMemberCode());
        if (!Boolean.TRUE.equals(addMbrCardStatusLog(memberCardStatusModifyVo))) {
            log.info("memberCardStatusModify memberCardStatusModifyVo 日志收集失败,memberCardStatusModifyVo:{}", JacksonUtil.bean2Json(memberCardStatusModifyVo));
            throw new MemberException("日志收集失败");
        }
        log.info("memberCardStatusModify memberCardStatusModifyVo 操作成功,memberCode:{}", memberCardStatusModifyVo.getMemberCode());
        return new ResponseData<>();
    }

    /**
     * 基本参数校验
     * @param memberCardStatusModifyVo
     * @return
     */
    protected ResponseData<String> baseValidationData(T memberCardStatusModifyVo) {
        if (memberCardStatusModifyVo == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "参数对象为空");
        } else if (memberCardStatusModifyVo.getSysCompanyId() == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "参数企业id为空");
        } else if (memberCardStatusModifyVo.getSysBrandId() == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "参数品牌id为空");
        } else if (memberCardStatusModifyVo.getActionType() == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "参数操作类型为空");
        } else if (StringUtils.isBlank(memberCardStatusModifyVo.getActionRemark())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "参数操操作说明为空");
        } else if (StringUtils.isBlank(memberCardStatusModifyVo.getMemberCode())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "参数操会员信息为空");
        }
        return new ResponseData<>();
    }
}
