package com.bizvane.members.facade.models;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/8/1 09:23
 * @Description:会员积分消费
 */
@Data
public class MemberIntegralConsumeModel implements Serializable {

    private static final long serialVersionUID = 7959268155470925444L;

    @ApiModelProperty(value = "积分流水id", name = "integralRecordId", example = "积分流水id")
    private Integer integralRecordId;

    @ApiModelProperty(value = "即将失效积分", name = "changeIntegral", example = "即将失效积分")
    private Integer changeIntegral;

    @ApiModelProperty(value = "即将失效时间", name = "effetiveTime", example = "即将失效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveTime;

    @ApiModelProperty(value = "会员可用积分", name = "countIntegral", example = "会员可用积分")
    private Integer countIntegral;
    
    @ApiModelProperty(value = "会员总收入积分", name = "integralCount", example = "会员总收入积分")
    private Integer integralCount;
}
