package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.ur.vo.MemberCouponExpireRequestVo;
import com.bizvane.members.facade.vo.MemberInfoForCouponSearchVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

//@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
@FeignClient(value = "membersncz", path = "${feign.client.members.path}")
public interface MemberInfoApiForCouponService {

	@RequestMapping(value = "/api/queryMemberInfoForCouponCondition", method = RequestMethod.POST)
	ResponseData<PageInfo<MembersInfoSearchPojo>> queryMemberInfoForCouponCondition(
			@RequestBody @Valid MemberInfoForCouponSearchVo memberInfoCouponSearchVo);


	@RequestMapping(value = "/api/selectCouponExpireMemberPage", method = RequestMethod.POST)
	ResponseData<PageInfo<MembersInfoSearchPojo>> selectCouponExpireMemberPage( @RequestBody MemberCouponExpireRequestVo expireRequestVo);
}
