package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.models.bo.AreaManagerAssetsRankBo;
import com.bizvane.members.facade.models.qywx.AreaManagerAssetsRankReqVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.util.List;

/**
 * 区经资产相关接口
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年07月27日 15:30:00
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
@Api(value = "区经资产相关接口",tags = {"区经资产相关接口"})
public interface AreaManagerAssetsApiService {

    @ApiOperation(value = "区经资产接口")
    @RequestMapping(value = "/api/areaManager/assets", method = RequestMethod.POST)
    ResponseData<List<AreaManagerAssetsRankBo>> assets(@RequestBody @Valid AreaManagerAssetsRankReqVo requestVo);
}
