package com.bizvane.members.facade.models;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/7/24 15:17
 * @Description:订单详细评价
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_order_detail_evaluate")
public class OrderDetailEvaluateModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = 353469785629083983L;

    @Id
    @ApiModelProperty(value = "订单评价详情主键", name = "mbrOrderDetailEvaluateId", example = "订单评价详情主键")
    private Long mbrOrderDetailEvaluateId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId", example = "品牌id")
    private Long brandId;

    @ApiModelProperty(value = "所属订单", name = "orderNo", example = "所属订单")
    private String orderNo;

    @ApiModelProperty(value = "所属订单详情编号", name = "orderDetailNo", example = "所属订单详情编号")
    private String orderDetailNo;

    @ApiModelProperty(value = "评价时间", name = "evaluateTime", example = "评价时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date evaluateTime;

    @ApiModelProperty(value = "评价内容", name = "evaluateContent", example = "评价内容")
    private String evaluateContent;

    @ApiModelProperty(value = "评价图片", name = "evaluatePicture", example = "评价图片")
    private String evaluatePicture;

    @ApiModelProperty(value = "评分（最高5分）", name = "evaluateScore", example = "评分（最高5分）")
    private Integer evaluateScore;

    @ApiModelProperty(value = "评价会员code", name = "evaluateMemberCode", example = "评价会员code")
    private String evaluateMemberCode;

    @ApiModelProperty(value = "会员所属门店", name = "serviceStoreId", example = "评价会员所属门店")
    private Long serviceStoreId;

    @ApiModelProperty(value = "商品名", name = "productName", example = "商品名")
    private String productName;

    @ApiModelProperty(value = "商品编号", name = "productNo", example = "商品编号")
    private String productNo;

    @ApiModelProperty(value = "颜色", name = "specification", example = "颜色")
    private String color;

    @ApiModelProperty(value = "大小", name = "specification", example = "大小")
    private String size;

    @ApiModelProperty(value = "线下更新时间", name = "offlineUpdateDate", example = "线下更新时间")
    private Date offlineUpdateDate;

    @ApiModelProperty(value = "线下企业code", name = "offlineCompanyCode", example = "线下企业code")
    private String offlineCompanyCode;

    @ApiModelProperty(value = "线下品牌code", name = "offlineBrandCode", example = "线下品牌code")
    private String offlineBrandCode;
}
