package com.bizvane.members.facade.enums;

import lombok.Getter;

/**
 * 自动标签状态枚举
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年11月04日 16:00:00
 */
@Getter
public enum AutoLabelStatusEnum {
    /**
     * 自动标签状态
     */
    NORMAL(1,"正常状态"),
    CALCULATE(2,"大数据计算中"),
    CALCULATE_FINISH(3,"计算完成"),
    WRITE(4,"CRM写入中"),
    WRITE_FINISH(5,"写入完成");

    private Integer status;

    private String msg;

    AutoLabelStatusEnum(Integer status, String msg) {
        this.status = status;
        this.msg = msg;
    }
}
