package com.bizvane.members.facade.service.api;


import com.bizvane.members.facade.vo.LevelRechargeCallBackRequestVO;
import com.bizvane.members.facade.vo.LevelRechargeShowRequestVO;
import com.bizvane.members.facade.vo.LevelRechargeShowResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberLevelRechargeApiService {

    @PostMapping("/levelRecharge/queryLevelRechargeShow")
    ResponseData<LevelRechargeShowResponseVO> queryLevelRechargeShow(@RequestBody @Valid LevelRechargeShowRequestVO levelRechargeShowRequestVO);

    @PostMapping("/levelRecharge/levelRechargeCallBack")
    ResponseData<String> levelRechargeCallBack(@RequestBody @Valid LevelRechargeCallBackRequestVO callBackRequestVO);


}
