package com.bizvane.members.facade.service.api;

import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.members.facade.models.bo.MbrFriendsBirthdayBO;
import com.bizvane.members.facade.models.bo.MbrFriendsByBirthdayBO;
import com.bizvane.members.facade.models.bo.MemberFriendsBO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author LJC
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberFriendApiService {

    @PostMapping(value = "/api/addOrModifyMemFriend")
    ResponseData addOrModifyMemFriend(@RequestBody MemberFriendsBO bo);

    @PostMapping(value = "/api/selectFriendByBirthday")
    ResponseData<PageInfo<MbrFriendsBirthdayBO>> selectFriendByBirthday(@RequestBody MbrFriendsByBirthdayBO bo);

}
