package com.bizvane.members.facade.es.pojo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/31.
 */
@Data
@EqualsAndHashCode
@Document(indexName = "distribution_member", type = "doc")
public class DistributionMemberInfoSearchPojo {

    @Id
    private Long mbrmemberid;
    //品牌号
    private Long brandid;
    //会员code
    private String membercode;
    //会员卡号
    private String cardno;
    //会员姓名
    private String name;
    //分销状态
    private Boolean distributionstate;
    //分销创建人
    private String distributioncreatename;
    //分销创建时间
    @Field(type = FieldType.Date)
    private Date distributioncreatetime;
    //分销修改人
    private String distributionmodifiedname;
    //分销修改时间
    @Field(type = FieldType.Date)
    private Date distributionmodifiedtime;
}
