package com.bizvane.members.facade.service.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.IntegralRecordVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

/**
 * @Author: houkai
 * @Date: 2018/7/30 19:34
 * @Description:会员通服务接口
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface MemberCardProgramApiService {
    /**
     * 查询会员卡基本信息
     *
     * @param memberCode
     * @return
     */
    @RequestMapping(value = "/api/memberCardProgram/queryMemberCardInfo", method = RequestMethod.POST)
    ResponseData<MemberCardLevelModel> queryMemberCardInfo(@RequestParam("memberCode") String memberCode);
    /**
     * 查询会员卡基本信息
     *
     * @param cardNo
     * @param sysBrandId
     * @return
     */
    @RequestMapping(value = "/api/memberCardProgram/queryMemberCardInfoByCardNo", method = RequestMethod.POST)
    ResponseData<MemberCardLevelModel> queryMemberCardInfoByCardNo(@RequestParam("cardNo") String cardNo,@RequestParam("sysBrandId") Long sysBrandId);


    /**
     * 查询会员可用积分和即将失效积分
     *
     * @param memberCode
     * @return
     */
    @RequestMapping(value = "/api/memberCardProgram/queryMemberIntegral", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> queryMemberIntegral(@RequestParam("memberCode") String memberCode);

    /**
     * 查询会员积分流水
     *
     * @param integralRecordVo
     * @return
     */
    @RequestMapping(value = "/api/memberCardProgram/queryMemberIntegralRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<IntegralRecordModel>> queryMemberIntegralRecord(@RequestBody IntegralRecordVo integralRecordVo);

    /**
     * 查询品牌下等级列表
     *
     * @param brandId
     * @param source
     * @return
     */
    @RequestMapping(value = "/api/memberCardProgram/queryLevelList", method = RequestMethod.POST)
    ResponseData<List<MbrLevelModel>> queryLevelList(@RequestParam("brandId") Long brandId, @RequestParam("source") String source);

}
