package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.models.po.AutoLabelPo;
import com.bizvane.members.facade.vo.AutoLabelListVo;
import com.bizvane.members.facade.vo.AutoLabelReqVo;
import com.bizvane.members.facade.vo.AutoLabelStatusVo;
import com.bizvane.members.facade.vo.AutoLabelVo;
import com.bizvane.members.facade.vo.vg.VGMemberSelectAutoLabelsForIntegralActivityResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 自动标签service
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年11月03日 20:06:00
 */
public interface AutoLabelService {
    /**
     * 添加自动标签
     *
     * @param autoLabelReqVo 新增自动标签vo
     * @param sysAccountPo   当前登录人信息
     * @return ResponseData
     */
    ResponseData<String> addAutoLabel(AutoLabelReqVo autoLabelReqVo, SysAccountPO sysAccountPo);

    /**
     * 修改自动标签
     *
     * @param autoLabelReqVo 修改自动标签vo
     * @param sysAccountPo   当前登录人信息
     * @return ResponseData
     */
    ResponseData<String> updateAutoLabel(AutoLabelReqVo autoLabelReqVo, SysAccountPO sysAccountPo);

    /**
     * 查询自动标签分组下的自动标签 分页
     *
     * @param autoLabelName     自动标签名称
     * @param autoLabelGroupId  自动标签分组id
     * @param sysCompanyId      企业id
     * @param brandId           品牌id
     * @param putAwayStatus     状态
     * @param pageNum
     * @param pageSize
     * @return ResponseData<PageInfo<AutoLabelListVo>>
     */
    ResponseData<PageInfo<AutoLabelListVo>> selectAutoLabels(String autoLabelName, Long autoLabelGroupId, Long sysCompanyId, Long brandId, Integer putAwayStatus, Integer pageNum, Integer pageSize);

    /**
     * 点击立即计算
     *
     * @param autoLabelId 自动标签id
     * @param sysAccountPo 当前登录人信息
     * @return ResponseData<String>
     */
    ResponseData<String> calculateImmediately(Long autoLabelId, SysAccountPO sysAccountPo);

    /**
     * 查询单个标签信息
     *
     * @param autoLabelId  自动标签id
     * @return ResponseData<AutoLabelListVo>
     */
    ResponseData<AutoLabelListVo> selectAutoLabel(@Param("autoLabelId") Long autoLabelId);
    /**
     * 查询单个标签信息,不含分组
     *
     * @param autoLabelId  自动标签id
     * @return ResponseData<AutoLabelPo>
     */
    ResponseData<AutoLabelPo> selectAutoLabelSingle(Long autoLabelId);

    /**
     * 取消计算
     *
     * @param autoLabelId 自动标签id
     * @param sysAccountPo 当前登录人信息
     * @return
     */
    ResponseData<String> cancelCalculate(Long autoLabelId, SysAccountPO sysAccountPo);

    /**
     * 查询自动标签 日志
     *
     * @param autoLabelId 自动标签id
     * @return ResponseData<AutoLabelVo>
     */
    ResponseData<AutoLabelVo> selectAutoLabelRecords(Long autoLabelId);

    /**
     * 品牌内 每日计算的标签数量
     *
     * @param sysAccountPo 当前登录人信息
     * @return ResponseData<Integer>
     */
    ResponseData<Integer> everydayCalLabelCount(SysAccountPO sysAccountPo);

    /**
     * 标签人群导出
     *
     * @param autoLabelId 自动标签id
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> exportAutoLabelMembers(Long autoLabelId, SysAccountPO sysAccountPo);


    /**
     * @description: 积分商城查询品牌下标签
     * @author gp.N
     * @date 2022-3-31
     **/
    ResponseData<List<VGMemberSelectAutoLabelsForIntegralActivityResponseVO>> selectAutoLabelsForIntegralActivity(Long sysCompanyId, Long brandId);

    /**
     * 自动标签上下架设置接口
     * @anthor shifeng
     * @param  autoLabelReqVos
     * @param  sysAccountPo
     * @return ResponseData
     * 2022-8-4 09:26:31
     */
    ResponseData<String> updateLabelPutAwayStatus(AutoLabelStatusVo autoLabelReqVos, SysAccountPO sysAccountPo);

}
