package com.bizvane.members.facade.models.tw;

import lombok.Data;

import java.util.Date;

@Data
public class MemberInfoSendTWDto {

    /**
     * 调用自研平台唯一标识
     */
    private String requestId;
    /**
     * 会员详细地址
     */
    private String address;
    /**
     * 会员生日 格式 : yyyy-mm-dd
     */
    private String birthday;
    /**
     * 品牌
     */
    private String brandCode;
    /**
     * 省
     */
    private String province;
    /**
     * 市
     */
    private String city;
    /**
     * 区
     */
    private String county;
    /**
     * 会员邮箱
     */
    private String email;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 会员名称
     */
    private String name;
    /**
     * 导购code
     */
    private String guideCode;
    /**
     * 会员身份证号
     */
    private String idCard;
    /**
     * 会员等级code
     */
    private String levelCode;

    /**
     * 开卡时间
     */
    private Date openCardTime;

    /**
     * 备注
     */
    private String remark;
    /**
     * 服务导购
     */
    private String serviceGuideCode;
    /**
     * 服务门店
     */
    private String serviceStoreCode;
    /**
     * 性别 : 1.女 2.男 3.未知
     */
    private Integer sex;

    /**
     * 会员注册渠道 : 1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他
     */
    private Integer source;

    /**
     * 会员注册渠道编码
     */
    private String sourceCode;
    /**
     * 注册门店code
     */
    private String storeCode;
    /**
     * 支付宝用户唯一标识
     */
    private String userId;
    /**
     * 微信unionId
     */
    private String wxUnionId;

    /**
     * 回呀卡号
     */
    private String cardNo;
}
