package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.models.MemberInfoModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/15.
 */
@Data
@NoArgsConstructor
@ToString
@EqualsAndHashCode(callSuper = true)
public class WxChannelInfoVo  extends MemberInfoModel implements Serializable {

    private static final long serialVersionUID = -4934655844169986094L;

    @ApiModelProperty(value = "微信渠道id", name = "mbrWxChannelId")
    private Long mbrWxChannelId;

    @ApiModelProperty(value = "会员code", name = "会员code")
    private String memberCode;

    @ApiModelProperty(value = "微信openId", name = "wxOpenId")
    private String wxOpenId;

    @ApiModelProperty(value = "微信UnionId", name = "wxUnionId")
    private String wxUnionId;

    @ApiModelProperty(value = "微信公众号Id", name = "wxPublicId")
    private Long wxPublicId;

    @ApiModelProperty(value = "微信appId", name = "appId")
    private String appId;

    @ApiModelProperty(value = "微信昵称", name = "wxNick")
    private String wxNick;

    @ApiModelProperty(name = "headPortraits", value = "微信头像")
    private String headPortraits;

    @ApiModelProperty(value = "是否关注：1未关注，2已关注", name = "memberName")
    private Integer focus;

    @ApiModelProperty(value = "关注时间", name = "focusTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date focusTime;

    @ApiModelProperty(value = "取关时间", name = "unFocusTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date unFocusTime;

    @ApiModelProperty(value = "推荐人id", name = "referrerOpenId")
    private String referrerOpenId;

    @ApiModelProperty(value = "绑卡状态：1未邦卡，2已帮卡", name = "cardStatus")
    private Integer cardStatus;

    @ApiModelProperty(value = "会员性别", name = "gender")
    private String gender;

    @ApiModelProperty(value = "会员省份", name = "province")
    private String province;

    @ApiModelProperty(value = "会员城市", name = "city")
    private String city;

    @ApiModelProperty(value = "会员县", name = "county")
    private String county;

    @ApiModelProperty(value = "是否小程序：1微信2小程序")
    private Integer miniProgram;

    @ApiModelProperty(name = "openCardGuideId" ,value = "开卡导购id")
    private Long openCardGuideId;

    @ApiModelProperty(name = "openCardStoreId", value = "开卡门店id")
    private Long openCardStoreId;
    
    @ApiModelProperty(name="channel",value="二维码渠道")
    private Integer channel;
}
