package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * 会员标签组model
 * <p>
 * 内部使用
 *
 * @author houkai
 */

@Data
@NoArgsConstructor
@Table(name = "t_mbr_label_type_def")
public class MemberLabelTypeModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = 2370079607334310303L;

    @Id
    @ApiModelProperty(value = "标签组id", name = "labelGroupId", example = "标签组id")
    private Long mbrLabelGroupDefId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "所属品牌", name = "brandId", example = "所属品牌")
    private Long brandId;

    @ApiModelProperty(value = "标签类型编号", name = "labelTypeCode", example = "标签类型编号")
    private String labelTypeCode;

    @ApiModelProperty(value = "标签类型名称", name = "labelTypeName", example = "标签类型名称")
    private String labelTypeName;

    /**
     * 标签组名list,excel导入使用
     */
    private Set<String> groupNameList;

    @ApiModelProperty(value = "排序字段",name = "sort")
    private Long sort;

}
