package com.bizvane.members.facade.enums;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * es返回值组合枚举
 */
public enum MemberFieldEnum {


    //group1 默认基础组合字段
    defaultField("会员默认字段", "memberCode", "cardNo", "erpId", "name", "gender", "phone", "countIntegral", "levelId", "wxUnionId", "openCardStoreId", "openCardGuideId", "serviceStoreId", "serviceGuideId"),

    //group2 微信基础字段
    wxBasicField("微信基本字段", "wxUnionId", "wxNick", "focus"),

    //group3 企业微信
    qwBasicField("企业微信基本字段", "membersFrom", "dateFrom", "mark", "companyFriend", "companyGuideFriends", "memberComment", "externalUserId"),

    //group4 大数据字段--消费次数消费金额
    consumeBehaviorField("大数据标签", "consumeAmountAll", "consumeAmount1", "consumeAmount3", "consumeNumberAll", "consumeNumber1", "consumeNumber3"),

    //升降级使用，目前只用到了12个月，24个月消费
    consumeBehaviorLevelField("大数据标签,升降级使用", "consumeAmountAll", "consumeAmount12", "consumeAmount24"),

    basicAdditionField("基础字段附加属性", "email", "emailStatus", "idCard", "headPortraits", "barCode"),

    addressField("会员地址相关", "province", "city", "county", "address"),

    birthdayField("会员生日及宝宝生日", "birthday", "birthdayMd", "babyBirthday", "babyBirthdayMd"),

    storeGuideField("门店导购信息", "openCardStoreId", "openCardGuideId", "serviceStoreId", "serviceGuideId"),

    levelName("等级名称", "levelId", "levelName","offlineLevelCode"),

    //单个字段
    memberCode("会员code", "memberCode"),

    cardNo("会员卡号", "cardNo"),

    erpId("会员线下唯一标志", "erpId"),

    name("会员名称", "name"),

    gender("会员性别", "1女2男3未知"),

    phone("会员手机号", "phone"),

    email("邮箱", "email"),

    idCard("身份证号", "idCard"),

    birthday("生日", "birthday"),

    birthdayMd("生日MMdd", "birthdayMd"),

    province("省份", "province"),

    city("城市", "city"),

    county("区", "county"),

    address("地址", "address"),

    headPortraits("头像url", "headPortraits"),

    barCode("会员卡条形码", "barCode"),

    cardStatus("微信绑卡状态 1未绑卡 2已绑卡", "cardStatus"),

    openCardTime("开卡时间", "openCardTime"),

    bindCardTime("绑卡时间", "bindCardTime"),

    effectiveTime("有效时间", "effectiveTime"),

    generalizeChannel("推广渠道", "generalizeChannel"),

    openCardChannelId("开卡渠道", "openCardChannelId"),

    allChannelIds("全渠道", "allChannelIds"),

    openCardGuideId("开卡导购id", "openCardGuideId"),

    openCardGuideCode("开卡导购code", "openCardGuideCode"),

    openCardStoreId("开卡门店id", "openCardStoreId"),

    openCardStoreCode("开卡门店Code" , "openCardStoreCode"),

    serviceStoreId("服务门店id", "serviceStoreId"),

    serviceGuideId("服务导购id", "serviceGuideId"),

    activeStore("活跃门店(快照)", "activeStore"),

    wxGeneralizeChannel("微信推广渠道", "wxGeneralizeChannel"),

    wxOpenId("微信openid", "wxOpenId"),

    wxUnionId("微信unionid", "wxUnionId"),

    wxPublicId("微信公众号id", "wxPublicId"),

    levelId("会员等级", "levelId"),

    labelIds("会员标签", "labelIds"),

    customLabelIds("自定义会员标签", "customLabelIds"),

    firstLandingCheck("是否首次登录：1是，2否", "firstLandingCheck"),

    cardUseStatus("vip卡状态 0未激活 1激活 2停用 3挂失 4冻结", "cardUseStatus"),

    balance("充值余额", "balance"),

    valid("数据有效性：1=有效；0=无效", "valid"),

    remark("备注", "remark"),

    createDate("创建时间", "createDate"),

    offlineCompanyCode("线下企业code", "offlineCompanyCode"),

    offlineBrandCode("线下品牌code", "offlineBrandCode"),


    countIntegral("会员积分", "countIntegral"),

    integralExchangeTicketCount("积分兑换券次数", "integralExchangeTicketCount"),

    membersFrom("会员来源分配", "membersFrom"),

    dateFrom("会员来源时间", "dateFrom"),

    mark("会员标注 0=未读；1已读", "mark"),

    companyFriend("是否企业好友 1=是 0=否(保留字段)", "companyFriend"),

    companyGuideFriends("会员导购好友集合，以-隔开", "companyGuideFriends"),

    memberComment("会员备注", "memberComment"),

    externalUserId("好友userid", "externalUserId"),

    activityId("活动id", "activityId"),

    activityType("活动类型", "activityType"),

    openCardScene("开卡场景 30扫码开卡 20绑卡 10自选开卡门店 0默认开卡门店(小于10可改)", "openCardScene"),

    channel("二维码渠道", "channel"),

    levelUpTime("升级时间", "levelUpTime"),

    babyBirthday("宝宝生日", "babyBirthday"),

    babyBirthdayMd("宝宝生日MMdd", "babyBirthdayMd"),

    firstOrderTime("首单时间", "firstOrderTime"),

    petCard("储值卡号", "petCard"),

    registerType("ur注册类型", "registerType"),

    emailStatus("邮箱验证状态 0未验证 1已验证", "emailStatus"),

    wxNick("微信昵称", "wxNick"),

    focus("是否关注公众号 1未关注2已关注3已取关", "focus"),

    offlineLevelCode("线下等级code","offlineLevelCode"),

    labelNames("标签名称","labelNames"),

    sysCompanyId("企业Id","sysCompanyId"),

    brandId("品牌Id","brandId"),

    consumeAmountAll("大数据标签,升降级使用-消费总额","consumeAmountAll"),

    consumeAmount12("大数据标签,升降级使用-12个月消费","consumeAmount12"),

    consumeAmount24("大数据标签,升降级使用-24个月消费","consumeAmount24")
    ;


    String description;

    String[] field;


    MemberFieldEnum(String description, String... field) {
        this.description = description;
        this.field = field;
    }


    public static Set<String> getField(MemberFieldEnum... memberFieldEnums) {
        if (memberFieldEnums == null) {
            return null;
        }
        Set<String> fieldSet = new HashSet<>();
        for (int i = 0; i < memberFieldEnums.length; i++) {
            String[] fields = memberFieldEnums[i].field;
            fieldSet.addAll(Arrays.asList(fields));
        }
        return fieldSet;
    }


}
