package com.bizvane.members.facade.utils;

import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyPo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.messagebase.model.vo.StandardTemplateResponseVO;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * guava緩存公共类
 */
public class GuavaUtils {

    /**
     * sysCompanyPo 缓存
     */
    public static String CACHE_COMPANY_KEY="members:cache_company_key:";
    public static Cache<String, SysCompanyPo> cacheSysCompanyPo = CacheBuilder.newBuilder()
            .maximumSize(100)
            .expireAfterWrite(10, TimeUnit.MINUTES)
            .build();
    public static void setSysCompanyPo(Long sysCompanyId,SysCompanyPo model){
        if(sysCompanyId!=null && model!=null)cacheSysCompanyPo.put(CACHE_COMPANY_KEY+sysCompanyId,model);
    }
    public static SysCompanyPo getSysCompanyPo(Long sysCompanyId){
        return cacheSysCompanyPo.getIfPresent(CACHE_COMPANY_KEY+sysCompanyId);
    }

    /**
     * sysBrandPo 缓存
     */
    public static String CACHE_BRAND_KEY="members:cache_brand_key:";
    public static Cache<String, SysBrandPo> cacheSysBrandPo = CacheBuilder.newBuilder()
            .maximumSize(1000)
            .expireAfterWrite(10, TimeUnit.MINUTES)
            .build();
    public static void setSysBrandPo(Long sysBrandId,SysBrandPo model){
        if(sysBrandId!=null && model!=null)cacheSysBrandPo.put(CACHE_BRAND_KEY+sysBrandId,model);
    }
    public static SysBrandPo getSysBrandPo(Long sysBrandId){
        return cacheSysBrandPo.getIfPresent(CACHE_BRAND_KEY+sysBrandId);
    }

    /**
     * sysBrandPoList 缓存
     */
    public static String CACHE_BRAND_LIST_KEY = "members:cache_brand_list_key:";
    public static Cache<String, List<SysBrandPo>> cacheSysBrandPoList = CacheBuilder.newBuilder()
            .maximumSize(10)
            .expireAfterWrite(10, TimeUnit.MINUTES)
            .build();

    public static void setSysBrandPoList(Long sysCompanyId, List<SysBrandPo> sysBrandPoList) {
        if (sysCompanyId != null && CollectionUtils.isNotEmpty(sysBrandPoList)) {
            cacheSysBrandPoList.put(CACHE_BRAND_LIST_KEY + sysCompanyId, sysBrandPoList);
        }
    }

    public static List<SysBrandPo> getSysBrandPoList(Long sysCompanyId) {
        return cacheSysBrandPoList.getIfPresent(CACHE_BRAND_LIST_KEY + sysCompanyId);
    }

    /**
     * membersSysModel 缓存
     */
    public static String CACHE_MEMBER_SYS_MODEL_KEY="members:cache_member_sys_model_key:";
    public static Cache<String, MembersSysModel> cacheMembersSysModel = CacheBuilder.newBuilder()
            .maximumSize(1000)
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build();
    public static void setMemberSysModel(Long sysBrandId,MembersSysModel model){
        if(sysBrandId!=null && model!=null)cacheMembersSysModel.put(CACHE_MEMBER_SYS_MODEL_KEY+sysBrandId,model);
    }
    public static MembersSysModel getMemberSysModel(Long sysBrandId){
        return cacheMembersSysModel.getIfPresent(CACHE_MEMBER_SYS_MODEL_KEY+sysBrandId);
    }

    /**
     * MbrLevelModel 缓存
     */
    public static String CACHE_MBR_LEVEL_KEY="members:cache_mbr_level_key:";
    public static Cache<String, MbrLevelModel> cacheMbrLevelModel = CacheBuilder.newBuilder()
            .maximumSize(1000)
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build();
    public static void setMbrLevelModel(Long mbrLevelId,MbrLevelModel model){
        if(mbrLevelId!=null && model!=null)cacheMbrLevelModel.put(CACHE_MBR_LEVEL_KEY+mbrLevelId,model);
    }
    public static MbrLevelModel getMbrLevelModel(Long mbrLevelId){
        return cacheMbrLevelModel.getIfPresent(CACHE_MBR_LEVEL_KEY+mbrLevelId);
    }

    /**
     * WxPublicPO 缓存
     */
    public static String CACHE_WX_PUBLIC_KEY="members:cache_wx_public_key:";
    public static Cache<String, WxPublicPO> cacheWxPublicModel = CacheBuilder.newBuilder()
            .maximumSize(1000)
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build();
    public static void setWxPublicModel(String appId,WxPublicPO model){
        if(StringUtil.isNotEmpty(appId) && model!=null)cacheWxPublicModel.put(CACHE_WX_PUBLIC_KEY+appId,model);
    }
    public static WxPublicPO getWxPublicModel(String appId){
        return cacheWxPublicModel.getIfPresent(CACHE_WX_PUBLIC_KEY+appId);
    }

    public static void setWxPublicModel(Long sysBrandId,WxPublicPO model){
        if(sysBrandId!=null && model!=null)cacheWxPublicModel.put(CACHE_WX_PUBLIC_KEY+sysBrandId,model);
    }
    public static WxPublicPO getWxPublicModel(Long sysBrandId){
        return cacheWxPublicModel.getIfPresent(CACHE_WX_PUBLIC_KEY+sysBrandId);
    }

    /**
     * sysStaffPo 缓存
     */
    public static String CACHE_SYS_STAFF_KEY="members:cache_sys_staff_key:";
    public static Cache<String, SysStaffPo> cacheSysStaffModel = CacheBuilder.newBuilder()
            .maximumSize(10000)
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build();
    public static void setSysStaffPo(Long sysStaffId,SysStaffPo model){
        if(sysStaffId!=null && model!=null)cacheSysStaffModel.put(CACHE_SYS_STAFF_KEY+sysStaffId,model);
    }
    public static SysStaffPo getSysStaffPo(Long sysStaffId){
        return cacheSysStaffModel.getIfPresent(CACHE_SYS_STAFF_KEY+sysStaffId);
    }

    /**
     * sysStorePo 缓存
     */
    public static String CACHE_SYS_STORE_KEY="members:cache_sys_store_key:";
    public static Cache<String, SysStorePo> cacheSysStoreKey = CacheBuilder.newBuilder()
            .maximumSize(10000)
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build();
    public static void setSysStorePo(Long sysStoreId,SysStorePo model){
        if(sysStoreId!=null && model!=null)cacheSysStoreKey.put(CACHE_SYS_STORE_KEY+sysStoreId,model);
    }
    public static SysStorePo getSysStorePo(Long sysStoreId){
        return cacheSysStoreKey.getIfPresent(CACHE_SYS_STORE_KEY+sysStoreId);
    }

    /**
     * MemberInfoModel 包含等级,缓存
     */
    public static String CACHE_MEMBER_INFO_MODEL_AND_LEVEL_KEY = "members:cache_member_info_model_and_level_key:";

    public static Cache<String, MemberInfoModel> cacheMemberInfoModelAndLevelKey = CacheBuilder.newBuilder()
            .maximumSize(500)
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build();

    public static void setMemberInfoModelAndLevelByMemberCode(String memberCode, MemberInfoModel memberInfoModel) {
        if (StringUtils.isNotBlank(memberCode) && memberInfoModel != null) {
            cacheMemberInfoModelAndLevelKey.put(CACHE_MEMBER_INFO_MODEL_AND_LEVEL_KEY + memberCode, memberInfoModel);
        }
    }
    public static MemberInfoModel getMemberInfoModelAndLevelByMemberCode(String memberCode){
        return cacheMemberInfoModelAndLevelKey.getIfPresent(CACHE_MEMBER_INFO_MODEL_AND_LEVEL_KEY + memberCode);
    }

    /**
     * MemberInfoModel 缓存
     */
    public static String CACHE_MEMBER_INFO_MODEL_KEY = "members:cache_member_info_model_key:";

    public static Cache<String, MemberInfoModel> cacheMemberInfoModelKey = CacheBuilder.newBuilder()
            .maximumSize(1000)
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build();

    public static void setMemberInfoModelByMemberCode(String memberCode, MemberInfoModel memberInfoModel) {
        if (StringUtils.isNotBlank(memberCode) && memberInfoModel != null) {
            cacheMemberInfoModelKey.put(CACHE_MEMBER_INFO_MODEL_KEY + memberCode, memberInfoModel);
        }
    }
    public static MemberInfoModel getMemberInfoModelByMemberCode(String memberCode){
        return cacheMemberInfoModelKey.getIfPresent(CACHE_MEMBER_INFO_MODEL_KEY + memberCode);
    }

    /**
     * StandardTemplateResponseVO 缓存
     */
    public static String CACHE_STANDARD_TEMPLATE_RESPONSE_VO_KEY = "members:cache_standard_template_response_vo_key:";

    public static Cache<String, StandardTemplateResponseVO> cacheStandardTemplateResponseVoKey = CacheBuilder.newBuilder()
            .maximumSize(1000)
            .expireAfterWrite(10, TimeUnit.MINUTES)
            .build();

    public static void setStandardTemplateResponseVo(Long sysCompanyId, Long sysBrandId, String templateType, StandardTemplateResponseVO standardTemplateResponseVO) {
        if (sysCompanyId != null && sysBrandId != null && StringUtils.isNotBlank(templateType) && standardTemplateResponseVO != null) {
            cacheStandardTemplateResponseVoKey.put(CACHE_STANDARD_TEMPLATE_RESPONSE_VO_KEY + "_" + sysCompanyId + "_" + sysBrandId + "_" + templateType, standardTemplateResponseVO);
        }
    }

    public static StandardTemplateResponseVO getStandardTemplateResponseVOByMemberCode(Long sysCompanyId, Long sysBrandId, String templateType) {
        return cacheStandardTemplateResponseVoKey.getIfPresent(CACHE_STANDARD_TEMPLATE_RESPONSE_VO_KEY + "_" + sysCompanyId + "_" + sysBrandId + "_" + templateType);
    }

    /**
     * sysCompanyPo 缓存
     */
    public static String CACHE_ORDER_COMPANY_KEY="members:order:cache_company_key:";
    public static Cache<String, SysCompanyPo> cacheOrderSysCompanyPo = CacheBuilder.newBuilder()
            .maximumSize(100)
            .expireAfterWrite(30, TimeUnit.SECONDS)
            .build();
    public static void setOrderSysCompanyPo(Long sysCompanyId,SysCompanyPo model){
        if(sysCompanyId!=null && model!=null)cacheOrderSysCompanyPo.put(CACHE_ORDER_COMPANY_KEY+sysCompanyId,model);
    }
    public static SysCompanyPo getOrderSysCompanyPo(Long sysCompanyId){
        return cacheOrderSysCompanyPo.getIfPresent(CACHE_ORDER_COMPANY_KEY+sysCompanyId);
    }

    /**
     * sysBrandPo 缓存
     */
    public static String CACHE_ORDER_BRAND_KEY="members:order:cache_brand_key:";
    public static Cache<String, SysBrandPo> cacheOrderSysBrandPo = CacheBuilder.newBuilder()
            .maximumSize(1000)
            .expireAfterWrite(30, TimeUnit.SECONDS)
            .build();
    public static void setOrderSysBrandPo(Long sysCompanyId,String brandCode,SysBrandPo model){
        if(sysCompanyId!=null && StringUtil.isNotEmpty(brandCode)&& model!=null)cacheOrderSysBrandPo.put(CACHE_ORDER_BRAND_KEY+sysCompanyId+"_"+brandCode,model);
    }
    public static SysBrandPo getOrderSysBrandPo(Long sysCompanyId,String brandCode){
        return cacheOrderSysBrandPo.getIfPresent(CACHE_ORDER_BRAND_KEY+sysCompanyId+"_"+brandCode);
    }

}
