package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.vo.StandardOpenCardRequestVo;
import com.bizvane.members.facade.vo.StandardOpenCardResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface StandardOpenCardApiService {

    @RequestMapping(value = "/api/standardApi/openCard", method = RequestMethod.POST)
    ResponseData<StandardOpenCardResponseVo> openCard(@RequestBody @Valid StandardOpenCardRequestVo standardOpenCardRequestVo);

    @RequestMapping(value = "/api/standardApi/standardUpdateMemberInfo", method = RequestMethod.POST)
    ResponseData<Integer> standardUpdateMemberInfo(@RequestBody @Valid StandardOpenCardRequestVo standardOpenCardRequestVo);
}
