package com.bizvane.members.facade.enums;

public enum DealFailEnum {

    /**
     * 会员
     */
    SUCCESS(9, "成功"),
    /**
     * 粉丝
     */
    EXCEL(0, "excel内容错误"),
    /**
     * 好友
     */
    MEMBER(1, "会员信息错误"),
    /**
     * 好友
     */
    BOJUN(2, "同步伯俊错误"),
    /**
     * 门店
     */
    STORE(3, "导购与门店不匹配"),
    /**
     * 好友
     */
    STAFF(4, "导购门店品牌错误"),

    /**
     * 门店不存在
     */
    STORE_NONE(5, "门店不存在"),
    /**
     * 导购不存在
     */
    STAFF_NONE(6, "导购不存在");


    private Integer code;

    private String msg;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }


    DealFailEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }


    //获取属性类型
    public static String getPropertyType(Integer code) {
        for (DealFailEnum type : DealFailEnum.values()) {
            if (code.equals(type.getCode())) {
                return type.getMsg();
            }
        }
        return "";
    }

}
