package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberLifecycleParameterModel;
import com.bizvane.members.facade.vo.MemberLifecycleParameterVo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;


/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/20.
 */
public interface MemberLifecycleParameterService {
    //添加自定义生命周期参数
    ResponseData<Integer> addMemberLifecycleParameter(MemberLifecycleParameterModel memberLifecycleParameterModel) throws MemberException;

    //修改参数限定时间
    ResponseData<Integer> updateMemberLifecycleParameter(MemberLifecycleParameterModel memberLifecycleParameterModel) throws MemberException;

    //删除自定义生命周期参数
    ResponseData<Integer> deleteMemberLifecycleParameterByBrandId(Long brandId) throws MemberException;

    //根据品牌id查询生命周期参数
    ResponseData<MemberLifecycleParameterModel> findMemberLifecycleParameterByBrandId(Long brandId) throws MemberException;

    /**
     * 大数据查询企业下所有生命周期列表
     *
     * @param offlineCompanyCode
     * @return
     */
    ResponseData<List<MemberLifecycleParameterVo>> queryAllLifecycle(String offlineCompanyCode);
}
