package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.po.MbrGrowthNumPO;
import com.bizvane.members.facade.models.po.MbrGrowthOrderPO;
import com.bizvane.members.facade.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

public interface MemberGrowthService {

    /**
     * 成长值配置信息
     *
     * @param configUpdateRequestVO
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> saveOrUpdateGrowthConfig(GrowthConfigSelectVO configUpdateRequestVO, SysAccountPO sysAccountPO);


    /**
     * 成长值配置信息展示
     *
     * @param sysAccountPO
     * @return
     */
    ResponseData<GrowthConfigSelectVO> selectGrowthConfig(SysAccountPO sysAccountPO);

    /**
     * 计算成长值使用的订单信息 无则新增 有则返回
     *
     * @param growthOrderPO 成长值订单关系表po
     * @return 新增条数
     */
    Integer saveGrowthOrder(MbrGrowthOrderPO growthOrderPO);


    /**
     * 会员成长值
     *
     * @param growthNumPO
     * @return
     */
    Integer saveGrowthMember(MbrGrowthNumPO growthNumPO);


    /**
     * 会员卡档案是否显示成长值及是否可调整成长值
     *
     * @param sysCompanyId
     * @param brandId
     * @return
     */
    ResponseData<GrowthShowConfigVO> selectGrowthShowConfig(Long sysCompanyId, Long brandId);

    /**
     * 手动调整成长值
     *
     * @param growthNumAdjustVO
     * @return
     */
    ResponseData<String> adjustMemberGrowthNum(GrowthNumAdjustVO growthNumAdjustVO, Long sysCompanyId, Long brandId);




    ResponseData<GrowthRecordResponseVO> selectGrowthRecord(GrowthRecordRequestVO growthRecordRequestVO,Long sysCompanyId,Long brandId);


    ResponseData<String> exportGrowthRecord(GrowthRecordRequestVO growthRecordRequestVO,SysAccountPO sysAccountPO);

}
