package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.LevelRecordModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.MemberCardBindWxRequestVo;
import com.bizvane.members.facade.vo.MemberCardBindWxResponseVo;
import com.bizvane.members.facade.vo.MemberCardInfoRes;
import com.bizvane.members.facade.vo.MemberInfoCardVo;
import com.bizvane.members.facade.vo.MemberInfoRes;
import com.bizvane.members.facade.vo.TaoBaoBindHistoryVo;
import com.bizvane.members.facade.vo.TurnoverWxBindRelationRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;
import java.util.Optional;

/**
 * @author houkai
 */
public interface MemberCardService {
    /**
     * 查询会员卡基本信息
     *
     * @param brandId
     * @param memberCode
     * @return
     */
    ResponseData<MemberCardInfoRes> queryMemberCardInfo(Long brandId, String memberCode);

    /**
     * 查询会员个人信息详情
     *
     * @param memberCode
     * @return
     */
    ResponseData<MemberInfoRes> queryMemberInfo(String memberCode);

    /**
     * 编辑会员个人信息
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    ResponseData updateMemberInfo(MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 查询会员等级变更记录
     *
     * @param memberCode
     * @return
     */
    ResponseData<List<LevelRecordModel>> queryMemberLevelRecord(String memberCode);

    /**
     * 查询会员卡片信息
     *
     * @param memberCode
     * @return
     */
    ResponseData<MemberInfoCardVo> queryMemberCard(String memberCode);

    /**
     * 更新会员手机号
     *
     * @param updateMemberPhoneRequestModel
     * @return
     */
    ResponseData updateMemberPhone(MemberInfoModel memberInfoModel);
    
    /**
     * 根据会员卡号查询微信绑定关系
     * @return
     */
    ResponseData<MemberCardBindWxResponseVo> queryMemberCardBindWxRelation(MemberCardBindWxRequestVo memberCardBindWxRequestVo);
    
    
    ResponseData<String> turnoverWxBindRelation(TurnoverWxBindRelationRequestVo turnoverWxBindRelationRequestVo,Optional<SysAccountPO> optional)throws MemberException;
    
    ResponseData<List<TaoBaoBindHistoryVo>> queryTaoBaoBindHistoryVo(String memberCode);

    ResponseData queryMemberChannel(String memberCode, Optional<SysAccountPO> optional);

    /**
     * 根据erpid更新会员等级
     * @param erpId
     * @param companyId
     * @param brandId
     * @param newLevelId
     * @param newLevelCode
     */
    void updateMemberLevelByErpIdOnline(String erpId, Long companyId, Long brandId, Long newLevelId, String newLevelCode);

    /**
     * 更新361会员线下等级
     * @param erpId
     * @param cardNo
     * @param phone
     * @param levelCode
     * @param brandId
     */
    void updateMemberLevelOffline361(String erpId, String cardNo, String phone, String levelCode, Long brandId);

    /**
     * 更新会员线下等级
     * @param erpId
     * @param cardNo
     * @param phone
     * @param newLevelCode
     * @param brandId
     */
    void updateMemberLevelOffline(String erpId, String cardNo, String phone, String newLevelCode, Long brandId);
}
