package com.bizvane.members.facade.service.api;


import com.bizvane.members.facade.vo.MemberGrowthShowRecordRequestVO;
import com.bizvane.members.facade.vo.MemberGrowthShowRecordResponseVO;
import com.bizvane.members.facade.vo.MemberGrowthShowRequestVO;
import com.bizvane.members.facade.vo.MemberGrowthShowResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberGrowthApiService {


    @RequestMapping(value = "/api/queryMemberGrowthShow", method = RequestMethod.POST)
    ResponseData<MemberGrowthShowResponseVO> queryMemberGrowthShow(@RequestBody @Valid MemberGrowthShowRequestVO memberGrowthShowRequestVO);

    @RequestMapping(value = "/api/queryMemberSelectRecord", method = RequestMethod.POST)
    ResponseData<MemberGrowthShowRecordResponseVO> queryMemberSelectRecord(@RequestBody @Valid MemberGrowthShowRecordRequestVO growthShowRecordRequestVO);

}
