package com.bizvane.members.facade.es.vo;

import com.bizvane.members.facade.enums.MemberFieldEnum;
import com.bizvane.members.facade.enums.MemberSortEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "会员高级搜索标准")
public class AdvancedFlexibleSearchVo {

    //group1-----会员返回字段及排序方式
    @ApiModelProperty(name = "memberFieldEnums", value = "会员组合返回字段")
    private MemberFieldEnum[] memberFieldEnums = {MemberFieldEnum.defaultField};

    @ApiModelProperty(name = "memberSortEnums", value = "会员组合排序字段")
    private MemberSortEnum[] memberSortEnums = {MemberSortEnum.defaultSort};

    //group2----游标id
    @ApiModelProperty(name = "scrollId", value = "游标id")
    private String scrollId;

    //group3----查询条件
    @ApiModelProperty(name = "sysCompanyId", value = "公司id")
    private Long sysCompanyId;

    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "levelIdList", value = "等级集合 区间内关系-或")
    private List<Long> levelIdList;

    @ApiModelProperty(name = "memberCodeList", value = "会员code集合 区间内关系-或")
    private List<String> memberCodeList;

    @ApiModelProperty(name = "serviceStoreIdList", value = "服务门店集合 区间内关系-或")
    private List<Long> serviceStoreIdList;

    @ApiModelProperty(name = "serviceGuideIdList", value = "服务导购集合 区间内关系-或")
    private List<Long> serviceGuideIdList;

    @ApiModelProperty(name = "openCardTimeSection", value = "开卡时间区间(支持半开区间) 区间内关系-或")
    private List<FlexibleTimeRange> openCardTimeSection;

    @ApiModelProperty(name = "birthdaySection", value = "生日时间区间(支持半开区间) 区间内关系-或")
    private List<FlexibleTimeRange> birthdaySection;

    @ApiModelProperty(name = "phoneList", value = "手机号集合")
    private List<String> phoneList;

    @ApiModelProperty(name = "cardNoList", value = "卡号集合")
    private List<String> cardNoList;

    @ApiModelProperty(name = "existsUnionId", value = "是否存在unionId")
    private Boolean existsUnionId;

    @ApiModelProperty(name = "membersInfoSearchVo", value = "会员卡档案条件")
    private MembersInfoSearchVo membersInfoSearchVo;

    @ApiModelProperty(name = "groupList", value = "分组id集合")
    private List<Long> groupList;

    @ApiModelProperty(name = "erpIdList", value = "erpId集合")
    private List<String> erpIdList;

    //group4----页size
    @ApiModelProperty(name = "pageSize", value = "页size")
    private Integer pageSize;

    @ApiModelProperty(name = "baisonSearchMemberCondition", value = "手机号或卡号")
    private String baisonSearchMemberCondition;

    @ApiModelProperty(name = "last90Growth",value = "为true时最近90天未消费成长值")
    private Boolean last90Growth;

    @ApiModelProperty(name = "last30Growth",value = "为true时最近30天未消费成长值")
    private Boolean last30Growth;

    @ApiModelProperty(name = "growthNum",value = "为true时存在会员成长值")
    private Boolean hasGrowthNum;
}
