package com.bizvane.members.facade.enums.vg;

/**
 *  锦泓品牌code对应字段
 */
public enum VGIntegralCostEnum {

    MALL_CLUB("MALL-CLUB","mallCostPercent"),
    YJ_CLUB("YJ-CLUB","yjCostPercent"),
    VG_CLUB("VG-CLUB","vgCostPercent"),
    TN_CLUB("TN-CLUB","tnCostPercent"),
    TZ_CLUB("TZ-CLUB","tzCostPercent"),
    TT_CLUB("TT-CLUB","ttCostPercent")
    ;

    private String code;

    private String name;

    public static String getNameByCode(String code) {
        for (VGIntegralCostEnum type : VGIntegralCostEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getName();
            }
        }
        return "";
    }

    VGIntegralCostEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }



}
