package com.bizvane.members.facade.enums;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/13.
 */
public enum CardStatusEnum {
    /**
     * 未绑卡
     */
    NOT_BIND_CARD(1, "未绑卡"),
    /**
     * 已绑卡
     */
    ALREADY_BIND_CARD(2,"已邦卡");

    private Integer code;

    private String msg;

    CardStatusEnum(Integer code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        for (CardStatusEnum type : CardStatusEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }
}
