package com.bizvane.members.facade.enums;

import com.bizvane.members.facade.constants.BasePropertyPrefix;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/31.
 */
public enum BasePropertyEnum {

    NAME(BasePropertyPrefix.NAME_, "姓名"),

    BIRTHDAY(BasePropertyPrefix.BIRTHDAY_, "生日"),

    PROVINCE(BasePropertyPrefix.PROVINCE_, "省"),

    CITY(BasePropertyPrefix.CITY_, "市"),

    COUNTY(BasePropertyPrefix.COUNTY_, "区/县"),

    ADDRESSES(BasePropertyPrefix.ADDRESSES_, "详细地址组合"),

    GENDER(BasePropertyPrefix.GENDER_, "性别"),

    EMAIL(BasePropertyPrefix.EMAIL_, "邮箱"),

    PHONE(BasePropertyPrefix.PHONE_, "手机号"),

    SERVICE_STORE(BasePropertyPrefix.SERVICE_STORE_, "服务门店"),

    SERVICE_GUIDE(BasePropertyPrefix.SERVICE_GUIDE_, "服务导购"),

    LEVEL(BasePropertyPrefix.LEVEL_, "会员等级"),
	
	INTEGRAL(BasePropertyPrefix.INTEGRAL_, "积分余额"),
	
	OPENCARD_STORE(BasePropertyPrefix.OPENCARD_, "开卡门店"),

    OPENCARDDATE(BasePropertyPrefix.OPENCARDDATE, "开卡时间");

    private String code;

    private String msg;

    BasePropertyEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static BasePropertyEnum getBasePropertyEnum(String code) {
        if (code == null) {
            return null;
        }
        for (BasePropertyEnum type : BasePropertyEnum.values()) {
            if (code.startsWith(type.getCode())) {
                return type;
            }
        }
        return null;
    }
}
