package com.bizvane.members.facade.service.inner;

import com.bizvane.couponfacade.models.bo.CompanyBrandBO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.UpdateMemberRelativeRequestVO;
import com.bizvane.members.facade.models.po.MbrMembersRelativePO;

import java.util.List;

/**
 * <p>
 * 会员亲属关系t_mbr_members_relative服务层接口
 * </p>
 * @author dingShiChen
 * @since 2019/10/12
 */
public interface MbrMembersRelativeService {

	/**
	 * 根据会员code和亲属姓名查询
	 * @param memberCode
	 * @param relativeName
	 * @param companyBrandBO
	 * @return
	 */
	MbrMembersRelativePO queryByMemberCodeAndRelativeName(String memberCode, String relativeName, CompanyBrandBO companyBrandBO);

	/**
	 * 新增会员亲属关系
	 * @param mbrMembersRelativePO
	 * @return
	 */
	Long createSelective(MbrMembersRelativePO mbrMembersRelativePO);

	/**
	 * 更新会员亲属关系
	 * @param mbrMembersRelativePO
	 */
	void updateSelective(MbrMembersRelativePO mbrMembersRelativePO);

	/**
	 * 更新会员亲属关系
	 * @param memberInfoModel
	 * @param relations
	 */
	void updateFromMemberUpdate(MemberInfoModel memberInfoModel, List<UpdateMemberRelativeRequestVO> relations);
}
